<?php

/**@Component */
class ControllerExtensionModuleLoginByTel extends Controller {

    private $error = array();
    private $module_code = "lbt";
    private $module_code_long = "login_by_tel";

    public function install() {

        $defaultSettings = array(
            "lbt_cfg_extension_status"                 => true,
            "lbt_cfg_log"                              => true,
            "lbt_cfg_mode"                             => "tel",
            "lbt_cfg_tel_is_unique"                    => true,
            "lbt_cfg_sms_extension"                    => "",
            "lbt_cfg_forgotten_password_by_sms_status" => false,
            "lbt_cfg_forgotten_password_by_sms_tmpls"  => array(),
            "lbt_cfg_passwordless_login_by_sms_status" => false,
            "lbt_cfg_passwordless_login_code_tmpls"    => array(),
        );

        $this->load->model('setting/setting');
        $this->model_setting_setting->editSetting($this->module_code, $defaultSettings);
        $this->model_setting_setting->editSetting('module_' . $this->module_code, array('module_' . $this->module_code . '_status' => true));

        $this->load->model('extension/module/login_by_tel');
        $this->model_extension_module_login_by_tel->install();
    }

    public function uninstall() {
        $this->load->model('extension/module/login_by_tel');
        $this->model_extension_module_login_by_tel->uninstall();
    }

    public function index() {

        $module_route  = 'extension/module/login_by_tel';
        $modules_route = 'marketplace/extension';


        $this->load->language('extension/module/login_by_tel');


        $this->document->setTitle($this->language->get('heading_title'));

        //Load the settings model. You can also add any other models you want to load here.
        $this->load->model('setting/setting');

        //Save the settings if the user has submitted the admin form (ie if someone has pressed save).
        if ($this->request->server['REQUEST_METHOD'] == 'POST' && $this->validate()) {

            $this->model_setting_setting->editSetting($this->module_code, $this->request->post);

            //Let the extension show as enabled/disabled in the module list
            if ($this->request->post['lbt_cfg_extension_status']) {
                $this->model_setting_setting->editSetting('module_' . $this->module_code_long, array('module_' . $this->module_code_long . '_status' => true));
            } else {
                $this->model_setting_setting->editSetting('module_' . $this->module_code_long, array('module_' . $this->module_code_long . '_status' => false));
            }

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link($modules_route, 'user_token=' . $this->session->data['user_token'] . '&type=module', 'SSL'));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }


        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'href'      => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], 'SSL'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        );

        $data['breadcrumbs'][] = array(
            'href'      => $this->url->link($modules_route, 'user_token=' . $this->session->data['user_token'] . '&type=module', 'SSL'),
            'text'      => $this->language->get('text_module'),
            'separator' => ' :: '
        );

        $data['breadcrumbs'][] = array(
            'href'      => $this->url->link($module_route, 'user_token=' . $this->session->data['user_token'] . '&type=module', 'SSL'),
            'text'      => $this->language->get('heading_title'),
            'separator' => ' :: '
        );


        $data['action'] = $this->url->link($module_route, 'user_token=' . $this->session->data['user_token'] . '&type=module', 'SSL');

        $data['cancel'] = $this->url->link($modules_route, 'user_token=' . $this->session->data['user_token'] . '&type=module', 'SSL');


        /*
         * Inject supported languages.
         */
        $this->load->model('localisation/language');

        $data['languages'] = array();

        $supportedLanguages = $this->model_localisation_language->getLanguages();

        foreach ($supportedLanguages as $result) {
            if ($result['status']) {
                $data['languages'][] = array(
                    'name' => $result['name'],
                    'code' => $result['code']
                );
            }
        }


        $data['available_sms_extensions'] = array();

        //guess installed SMS extensions;
        if (file_exists(DIR_APPLICATION . 'controller/extension/module/smshare_core.php')) {
            $data['available_sms_extensions'][] = array(
                "key" => "core",
                "val" => "Smshare core"
            );
        }

        if (file_exists(DIR_APPLICATION . 'controller/extension/module/smshare_core_saas.php')) {
            $data['available_sms_extensions'][] = array(
                "key" => "core-saas",
                "val" => "Smshare core (saas)"
            );
        }


        /*
         *
         */
        $config_data = array(
            "lbt_cfg_extension_status",
            "lbt_cfg_log",
            "lbt_cfg_mode",
            "lbt_cfg_tel_is_unique",
            "lbt_cfg_sms_extension",
            "lbt_cfg_forgotten_password_by_sms_status",
            "lbt_cfg_forgotten_password_by_sms_tmpls",
            "lbt_cfg_passwordless_login_by_sms_status",
            "lbt_cfg_passwordless_login_code_tmpls",
        );

        foreach ($config_data as $conf) {
            if (isset($this->request->post[$conf])) {
                $data[$conf] = $this->request->post[$conf];
            } else {
                $data[$conf] = $this->config->get($conf);
            }


            if (empty($data[$conf])) {
                if ($conf == "lbt_cfg_forgotten_password_by_sms_tmpls") {
                    $data[$conf] = array();
                    foreach ($supportedLanguages as $supportedLanguage) {
                        $data[$conf][$supportedLanguage['code']] = "Please click on the link below to reset your password: {reset_link}";
                        break;
                    }
                }
                if ($conf == "lbt_cfg_passwordless_login_code_tmpls") {
                    $data[$conf] = array();
                    foreach ($supportedLanguages as $supportedLanguage) {
                        $data[$conf][$supportedLanguage['code']] = "Enter the code below to login: {login_code} or click on the magic link below to login: {login_link}";
                        break;
                    }
                }
            }
        }

        $data['tab_general']      = $this->load->view("extension/module/lbt/settings/lbt_tab_general", $data);
        $data['tab_forgotten']    = $this->load->view("extension/module/lbt/settings/lbt_tab_forgotten", $data);
        $data['tab_passwordless'] = $this->load->view("extension/module/lbt/settings/lbt_tab_passwordless", $data);

        $data['header']      = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer']      = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/module/lbt/settings/login_by_tel', $data));
    }


    private function validate() {
        if (!isset($this->request->post['lbt_cfg_sms_extension']) && $this->request->post['lbt_cfg_forgotten_password_by_sms_status']) {
            $this->error['warning'] = "Select the SMS extension to be used when sending SMS";
        }

        return !$this->error;
    }

}