<?php
class ControllerExtensionModuleTelephoneWithCountryCodeSainent extends Controller {
	private $error = array(); 
	 
	public function index() {   
		$this->language->load('extension/module/telephonewithcountrycode_sainent');

		$this->document->setTitle($this->language->get('text_title'));
		
		$this->load->model('setting/setting');
			
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('module_telephonewithcountrycode_sainent', $this->request->post);		
			
			$this->session->data['success'] = $this->language->get('text_success');
			
			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));

		}

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
				
		$data['heading_title'] = $this->language->get('text_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
				
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		
		$data['text_select_all'] = $this->language->get('text_select_all');
		$data['text_unselect_all'] = $this->language->get('text_unselect_all');

		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_preferred_countries'] = $this->language->get('entry_preferred_countries');
		$data['info_preferred_countries'] = $this->language->get('info_preferred_countries');
		$data['entry_allowed_countries'] = $this->language->get('entry_allowed_countries');
		$data['info_allowed_countries'] = $this->language->get('info_allowed_countries');
		$data['entry_custom_field'] = $this->language->get('entry_custom_field');
		$data['info_custom_field'] = $this->language->get('info_custom_field');
		
		$data['help_allowed_countries'] = $this->language->get('help_allowed_countries');
		$data['help_preferred_countries'] = $this->language->get('help_preferred_countries');
		$data['help_custom_field'] = $this->language->get('help_custom_field');
		
  		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_title'),
			'href' => $this->url->link('extension/module/telephonewithcountrycode_sainent', 'user_token=' . $this->session->data['user_token'], true)
		);
		
		$data['action'] = $this->url->link('extension/module/telephonewithcountrycode_sainent', 'user_token=' . $this->session->data['user_token'], true);
		
		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);
		
		$this->load->model('localisation/country');
		
		$data['countries'] = $this->model_localisation_country->getCountries();
		
		$this->load->model('customer/custom_field');
		
		$filter_data = array(
			'start' => 0,
			'limit' => $this->model_customer_custom_field->getTotalCustomFields(),
		);

		$data['custom_fields'] = $this->model_customer_custom_field->getCustomFields($filter_data);
		
		if (isset($this->request->post['module_telephonewithcountrycode_sainent_preferred_countries'])) {
			$data['module_telephonewithcountrycode_sainent_preferred_countries'] = $this->request->post['module_telephonewithcountrycode_sainent_preferred_countries'];
		} else {
			$data['module_telephonewithcountrycode_sainent_preferred_countries'] = $this->config->get('module_telephonewithcountrycode_sainent_preferred_countries');
		}
		
		if (isset($this->request->post['module_telephonewithcountrycode_sainent_allowed_countries'])) {
			$data['module_telephonewithcountrycode_sainent_allowed_countries'] = $this->request->post['module_telephonewithcountrycode_sainent_allowed_countries'];
		} else {
			$data['module_telephonewithcountrycode_sainent_allowed_countries'] = $this->config->get('module_telephonewithcountrycode_sainent_allowed_countries');
		}
		
		if (isset($this->request->post['module_telephonewithcountrycode_sainent_custom_field'])) {
			$data['module_telephonewithcountrycode_sainent_custom_field'] = $this->request->post['module_telephonewithcountrycode_sainent_custom_field'];
		} else {
			$data['module_telephonewithcountrycode_sainent_custom_field'] = $this->config->get('module_telephonewithcountrycode_sainent_custom_field');
		}
		
		if (isset($this->request->post['module_telephonewithcountrycode_sainent_status'])) {
			$data['module_telephonewithcountrycode_sainent_status'] = $this->request->post['module_telephonewithcountrycode_sainent_status'];
		} else {
			$data['module_telephonewithcountrycode_sainent_status'] = $this->config->get('module_telephonewithcountrycode_sainent_status');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/telephonewithcountrycode_sainent', $data));
	}
	
	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/telephonewithcountrycode_sainent')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		if (!$this->error) {
			return true;
		} else {
			return false;
		}
	}
}
