<?php
class ControllerExtensionModuleWebskyOtp extends Controller
{
	private $error = array();

	public function index()
	{
		$this->load->language('extension/module/websky_otp');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		$this->load->model('tool/image');
		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {

			$this->model_setting_setting->editSetting('module_websky_otp', $this->request->post);
			// SEO URL
			$this->db->query("DELETE FROM " . DB_PREFIX . "seo_url WHERE query = 'websky_otp'");
			if (isset($this->request->post['module_websky_otp_seo'])) {
				foreach ($this->request->post['module_websky_otp_seo'] as $store_id => $keyword) {
					if (!empty($keyword)) {
						$this->db->query("INSERT INTO " . DB_PREFIX . "seo_url SET store_id = '" . (int) $store_id . "', query = 'websky_otp', keyword = '" . $this->db->escape($keyword) . "'");
					}

				}
			}

			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));

		}
		$data['user_token'] = $this->session->data['user_token'];
		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		if (isset($this->error['keyword'])) {
			$data['error_keyword'] = $this->error['keyword'];
		} else {
			$data['error_keyword'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/websky_otp', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/module/websky_otp', 'user_token=' . $this->session->data['user_token'], true);


		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$data['imageurl'] = HTTP_CATALOG . 'image/';
		$data['designs'] = array(
			"2" => $this->language->get('special'),
			"3" => $this->language->get('heading_footer'),
			"4" => $this->language->get('popup'),
		);
		if (isset($this->request->post['module_websky_otp_designs'])) {
			$data['module_websky_otp_designs'] = $this->request->post['module_websky_otp_designs'];
		} elseif ($this->config->get('module_websky_otp_designs')) {
			$data['module_websky_otp_designs'] = $this->config->get('module_websky_otp_designs');
		} else {
			$data['module_websky_otp_designs'] = 3;
		}


		if (isset($this->request->post['module_websky_otp_paterncode'])) {
			$data['module_websky_otp_paterncode'] = $this->request->post['module_websky_otp_paterncode'];
		} else {
			$data['module_websky_otp_paterncode'] = $this->config->get('module_websky_otp_paterncode');
		}
		if (isset($this->request->post['module_websky_otp_status'])) {
			$data['module_websky_otp_status'] = $this->request->post['module_websky_otp_status'];
		} else {
			$data['module_websky_otp_status'] = $this->config->get('module_websky_otp_status');
		}


		if (isset($this->request->post['module_websky_otp_welcome_text'])) {
			$data['module_websky_otp_welcome_text'] = $this->request->post['module_websky_otp_welcome_text'];
		} elseif ($this->config->get('module_websky_otp_welcome_text')) {
			$data['module_websky_otp_welcome_text'] = $this->config->get('module_websky_otp_welcome_text');
		} else {
			$data['module_websky_otp_welcome_text'] = array(
				'1' => 'welcome to my store',
				'2' => 'به فروشگاه خوش آمدید'
			);
		}
       

		if (isset($this->request->post['module_websky_otp_text_continue_otp'])) {
			$data['module_websky_otp_text_continue_otp'] = $this->request->post['module_websky_otp_text_continue_otp'];
		} elseif ($this->config->get('module_websky_otp_text_continue_otp')) {
			$data['module_websky_otp_text_continue_otp'] = $this->config->get('module_websky_otp_text_continue_otp');
		} else {
			$data['module_websky_otp_text_continue_otp'] = array(
				'1' => 'continue',
				'2' => ' ادامه '
			);
		}

	
		if (isset($this->request->post['module_websky_otp_welcome_text_header'])) {
			$data['module_websky_otp_welcome_text_header'] = $this->request->post['module_websky_otp_welcome_text_header'];
		} else {
			$data['module_websky_otp_welcome_text_header'] = $this->config->get('module_websky_otp_welcome_text_header');
		}

		if (isset($this->request->post['module_websky_otp_text_chenge'])) {
			$data['module_websky_otp_text_chenge'] = $this->request->post['module_websky_otp_text_chenge'];
		} else {
			$data['module_websky_otp_text_chenge'] = $this->config->get('module_websky_otp_text_chenge');
		}

		if (isset($this->request->post['module_websky_otp_text_Confirm_code'])) {
			$data['module_websky_otp_text_Confirm_code'] = $this->request->post['module_websky_otp_text_Confirm_code'];
		} else {
			$data['module_websky_otp_text_Confirm_code'] = $this->config->get('module_websky_otp_text_Confirm_code');
		}

		if (isset($this->request->post['module_websky_otp_text_complate_user'])) {
			$data['module_websky_otp_text_complate_user'] = $this->request->post['module_websky_otp_text_complate_user'];
		} else {
			$data['module_websky_otp_text_complate_user'] = $this->config->get('module_websky_otp_text_complate_user');
		}

		if (isset($this->request->post['module_websky_otp_text_delay'])) {
			$data['module_websky_otp_text_delay'] = $this->request->post['module_websky_otp_text_delay'];
		} else {
			$data['module_websky_otp_text_delay'] = $this->config->get('module_websky_otp_text_delay');
		}
       

		if (isset($this->request->post['module_websky_otp_text_login_sms'])) {
			$data['module_websky_otp_text_login_sms'] = $this->request->post['module_websky_otp_text_login_sms'];
		} else {
			$data['module_websky_otp_text_login_sms'] = $this->config->get('module_websky_otp_text_login_sms');
		}

		if (isset($this->request->post['module_websky_otp_text_login_password'])) {
			$data['module_websky_otp_text_login_password'] = $this->request->post['module_websky_otp_text_login_password'];
		} else {
			$data['module_websky_otp_text_login_password'] = $this->config->get('module_websky_otp_text_login_password');
		}

		if (isset($this->request->post['module_websky_otp_text_password'])) {
			$data['module_websky_otp_text_password'] = $this->request->post['module_websky_otp_text_password'];
		} else {
			$data['module_websky_otp_text_password'] = $this->config->get('module_websky_otp_text_password');
		}

		if (isset($this->request->post['module_websky_otp_text_phone'])) {
			$data['module_websky_otp_text_phone'] = $this->request->post['module_websky_otp_text_phone'];
		} else {
			$data['module_websky_otp_text_phone'] = $this->config->get('module_websky_otp_text_phone');
		}

		if (isset($this->request->post['module_websky_otp_text_wait'])) {
			$data['module_websky_otp_text_wait'] = $this->request->post['module_websky_otp_text_wait'];
		} else {
			$data['module_websky_otp_text_wait'] = $this->config->get('module_websky_otp_text_wait');
		}

		if (isset($this->request->post['module_websky_otp_text_confirm'])) {
			$data['module_websky_otp_text_confirm'] = $this->request->post['module_websky_otp_text_confirm'];
		} else {
			$data['module_websky_otp_text_confirm'] = $this->config->get('module_websky_otp_text_confirm');
		}

		if (isset($this->request->post['module_websky_otp_text_header'])) {
			$data['module_websky_otp_text_header'] = $this->request->post['module_websky_otp_text_header'];
		} else {
			$data['module_websky_otp_text_header'] = $this->config->get('module_websky_otp_text_header');
		}

		if (isset($this->request->post['module_websky_otp_text_sendcode'])) {
			$data['module_websky_otp_text_sendcode'] = $this->request->post['module_websky_otp_text_sendcode'];
		} else {
			$data['module_websky_otp_text_sendcode'] = $this->config->get('module_websky_otp_text_sendcode');
		}
     

		if (isset($this->request->post['module_websky_otp_text_telephone_email'])) {
			$data['module_websky_otp_text_telephone_email'] = $this->request->post['module_websky_otp_text_telephone_email'];
		} else {
			$data['module_websky_otp_text_telephone_email'] = $this->config->get('module_websky_otp_text_telephone_email');
		}

		if (isset($this->request->post['module_websky_otp_text_login_or_register'])) {
			$data['module_websky_otp_text_login_or_register'] = $this->request->post['module_websky_otp_text_login_or_register'];
		} else {
			$data['module_websky_otp_text_login_or_register'] = $this->config->get('module_websky_otp_text_login_or_register');
		}
         
		if (isset($this->request->post['module_websky_otp_text_firstname'])) {
			$data['module_websky_otp_text_firstname'] = $this->request->post['module_websky_otp_text_firstname'];
		} else {
			$data['module_websky_otp_text_firstname'] = $this->config->get('module_websky_otp_text_firstname');
		}

		if (isset($this->request->post['module_websky_otp_text_lastname'])) {
			$data['module_websky_otp_text_lastname'] = $this->request->post['module_websky_otp_text_lastname'];
		} else {
			$data['module_websky_otp_text_lastname'] = $this->config->get('module_websky_otp_text_lastname');
		}

		if (isset($this->request->post['module_websky_otp_text_email'])) {
			$data['module_websky_otp_text_email'] = $this->request->post['module_websky_otp_text_email'];
		} else {
			$data['module_websky_otp_text_email'] = $this->config->get('module_websky_otp_text_email');
		}

		if (isset($this->request->post['module_websky_otp_text_login_fill_form'])) {
			$data['module_websky_otp_text_login_fill_form'] = $this->request->post['module_websky_otp_text_login_fill_form'];
		} else {
			$data['module_websky_otp_text_login_fill_form'] = $this->config->get('module_websky_otp_text_login_fill_form');
		}
   
		if (isset($this->request->post['module_websky_otp_text_edit'])) {
			$data['module_websky_otp_text_edit'] = $this->request->post['module_websky_otp_text_edit'];
		} else {
			$data['module_websky_otp_text_edit'] = $this->config->get('module_websky_otp_text_edit');
		}

		if (isset($this->request->post['module_websky_otp_text_telephone'])) {
			$data['module_websky_otp_text_telephone'] = $this->request->post['module_websky_otp_text_telephone'];
		} else {
			$data['module_websky_otp_text_telephone'] = $this->config->get('module_websky_otp_text_telephone');
		}

		if (isset($this->request->post['module_websky_otp_error_phone_valid'])) {
			$data['module_websky_otp_error_phone_valid'] = $this->request->post['module_websky_otp_error_phone_valid'];
		} else {
			$data['module_websky_otp_error_phone_valid'] = $this->config->get('module_websky_otp_error_phone_valid');
		}

		if (isset($this->request->post['module_websky_otp_error_phone_email_valid'])) {
			$data['module_websky_otp_error_phone_email_valid'] = $this->request->post['module_websky_otp_error_phone_email_valid'];
		} else {
			$data['module_websky_otp_error_phone_email_valid'] = $this->config->get('module_websky_otp_error_phone_email_valid');
		}

		if (isset($this->request->post['module_websky_otp_error_login'])) {
			$data['module_websky_otp_error_login'] = $this->request->post['module_websky_otp_error_login'];
		} else {
			$data['module_websky_otp_error_login'] = $this->config->get('module_websky_otp_error_login');
		}

		if (isset($this->request->post['module_websky_otp_error_code'])) {
			$data['module_websky_otp_error_code'] = $this->request->post['module_websky_otp_error_code'];
		} else {
			$data['module_websky_otp_error_code'] = $this->config->get('module_websky_otp_error_code');
		}

		if (isset($this->request->post['module_websky_otp_error_password'])) {
			$data['module_websky_otp_error_password'] = $this->request->post['module_websky_otp_error_password'];
		} else {
			$data['module_websky_otp_error_password'] = $this->config->get('module_websky_otp_error_password');
		}


		if (isset($this->request->post['module_websky_otp_error_email'])) {
			$data['module_websky_otp_error_email'] = $this->request->post['module_websky_otp_error_email'];
		} else {
			$data['module_websky_otp_error_email'] = $this->config->get('module_websky_otp_error_email');
		}
      
		if (isset($this->request->post['module_websky_otp_error_exists'])) {
			$data['module_websky_otp_error_exists'] = $this->request->post['module_websky_otp_error_exists'];
		} else {
			$data['module_websky_otp_error_exists'] = $this->config->get('module_websky_otp_error_exists');
		}

		if (isset($this->request->post['module_websky_otp_error_firstname'])) {
			$data['module_websky_otp_error_firstname'] = $this->request->post['module_websky_otp_error_firstname'];
		} else {
			$data['module_websky_otp_error_firstname'] = $this->config->get('module_websky_otp_error_firstname');
		}

		if (isset($this->request->post['module_websky_otp_error_lastname'])) {
			$data['module_websky_otp_error_lastname'] = $this->request->post['module_websky_otp_error_lastname'];
		} else {
			$data['module_websky_otp_error_lastname'] = $this->config->get('module_websky_otp_error_lastname');
		}

		if (isset($this->request->post['module_websky_otp_error_email_register'])) {
			$data['module_websky_otp_error_email_register'] = $this->request->post['module_websky_otp_error_email_register'];
		} else {
			$data['module_websky_otp_error_email_register'] = $this->config->get('module_websky_otp_error_email_register');
		}

		
		if (isset($this->request->post['module_websky_otp_error_user'])) {
			$data['module_websky_otp_error_user'] = $this->request->post['module_websky_otp_error_user'];
		} else {
			$data['module_websky_otp_error_user'] = $this->config->get('module_websky_otp_error_user');
		}

		
		if (isset($this->request->post['module_websky_otp_success_user'])) {
			$data['module_websky_otp_success_user'] = $this->request->post['module_websky_otp_success_user'];
		} else {
			$data['module_websky_otp_success_user'] = $this->config->get('module_websky_otp_success_user');
		}

		
		if (isset($this->request->post['module_websky_otp_success_confirm'])) {
			$data['module_websky_otp_success_confirm'] = $this->request->post['module_websky_otp_success_confirm'];
		} else {
			$data['module_websky_otp_success_confirm'] = $this->config->get('module_websky_otp_success_confirm');
		}
		if (isset($this->request->post['module_websky_otp_verify_text_login'])) {
			$data['module_websky_otp_verify_text_login'] = $this->request->post['module_websky_otp_verify_text_login'];
		} else {
			$data['module_websky_otp_verify_text_login'] = $this->config->get('module_websky_otp_verify_text_login');
		}
		if (isset($this->request->post['module_websky_otp_verify_text_new'])) {
			$data['module_websky_otp_verify_text_new'] = $this->request->post['module_websky_otp_verify_text_new'];
		} else {
			$data['module_websky_otp_verify_text_new'] = $this->config->get('module_websky_otp_verify_text_new');
		}
		if (isset($this->request->post['module_websky_otp_verify_text_new_test'])) {
			$data['module_websky_otp_verify_text_new_test'] = $this->request->post['module_websky_otp_verify_text_new_test'];
		} else {
			$data['module_websky_otp_verify_text_new_test'] = $this->config->get('module_websky_otp_verify_text_new_test');
		}

		if (isset($this->request->post['module_websky_otp_text_unlock'])) {
			$data['module_websky_otp_text_unlock'] = $this->request->post['module_websky_otp_text_unlock'];
		} else {
			$data['module_websky_otp_text_unlock'] = $this->config->get('module_websky_otp_text_unlock');
		}

		if (isset($this->request->post['module_websky_otp_error_approved'])) {
			$data['module_websky_otp_error_approved'] = $this->request->post['module_websky_otp_error_approved'];
		} else {
			$data['module_websky_otp_error_approved'] = $this->config->get('module_websky_otp_error_approved');
		}

		if (isset($this->request->post['module_websky_otp_error_attempts'])) {
			$data['module_websky_otp_error_attempts'] = $this->request->post['module_websky_otp_error_attempts'];
		} else {
			$data['module_websky_otp_error_attempts'] = $this->config->get('module_websky_otp_error_attempts');
		}

		if (isset($this->request->post['module_websky_otp_verify_text_login_test'])) {
			$data['module_websky_otp_verify_text_login_test'] = $this->request->post['module_websky_otp_verify_text_login_test'];
		} else {
			$data['module_websky_otp_verify_text_login_test'] = $this->config->get('module_websky_otp_verify_text_login_test');
		}

		 
		if (isset($this->request->post['module_websky_otp_text_chenge_email'])) {
			$data['module_websky_otp_text_chenge_email'] = $this->request->post['module_websky_otp_text_chenge_email'];
		} else {
			$data['module_websky_otp_text_chenge_email'] = $this->config->get('module_websky_otp_text_chenge_email');
		}


		if (isset($this->request->post['module_websky_otp_password'])) {
			$data['module_websky_otp_password'] = $this->request->post['module_websky_otp_password'];
		} elseif ($this->config->get('module_websky_otp_password')) {
			$data['module_websky_otp_password'] = $this->config->get('module_websky_otp_password');
		} else {
			$data['module_websky_otp_password'] = 0;
		}
		if (isset($this->request->post['module_websky_otp_international'])) {
			$data['module_websky_otp_international'] = $this->request->post['module_websky_otp_international'];
		} else {
			$data['module_websky_otp_international'] = $this->config->get('module_websky_otp_international');
		}
		if (isset($this->request->post['module_websky_otp_login'])) {
			$data['module_websky_otp_login'] = $this->request->post['module_websky_otp_login'];
		} elseif ($this->config->get('module_websky_otp_login')) {
			$data['module_websky_otp_login'] = $this->config->get('module_websky_otp_login');
		} else {
			$data['module_websky_otp_login'] = 0;
		}

		if (isset($this->request->post['module_websky_otp_delay'])) {
			$data['module_websky_otp_delay'] = $this->request->post['module_websky_otp_delay'];
		} elseif ($this->config->get('module_websky_otp_delay')) {
			$data['module_websky_otp_delay'] = $this->config->get('module_websky_otp_delay');
		} else {
			$data['module_websky_otp_delay'] = "20";
		}

		if (isset($this->request->post['module_websky_otp_limit_time'])) {
			$data['module_websky_otp_limit_time'] = $this->request->post['module_websky_otp_limit_time'];
		} elseif ($this->config->get('module_websky_otp_limit_time')) {
			$data['module_websky_otp_limit_time'] = $this->config->get('module_websky_otp_limit_time');
		} else {
			$data['module_websky_otp_limit_time'] = "3";
		}

		
		if (isset($this->request->post['module_websky_otp_block_time'])) {
			$data['module_websky_otp_block_time'] = $this->request->post['module_websky_otp_block_time'];
		} elseif ($this->config->get('module_websky_otp_block_time')) {
			$data['module_websky_otp_block_time'] = $this->config->get('module_websky_otp_block_time');
		} else {
			$data['module_websky_otp_block_time'] = "3600";
		}

		if (isset($this->request->post['module_websky_otp_image'])) {
			$data['module_websky_otp_image'] = $this->request->post['module_websky_otp_image'];
		} elseif ($this->config->get('module_websky_otp_image')) {
			$data['module_websky_otp_image'] = $this->config->get('module_websky_otp_image');
		} else {
			$data['module_websky_otp_image'] = "catalog/images.png";
		}

		if (isset($this->request->post['module_websky_otp_image_verify'])) {
			$data['module_websky_otp_image_verify'] = $this->request->post['module_websky_otp_image_verify'];
		} elseif ($this->config->get('module_websky_otp_image_verify')) {
			$data['module_websky_otp_image_verify'] = $this->config->get('module_websky_otp_image_verify');
		} else {
			$data['module_websky_otp_image_verify'] = "catalog/verify.png";
		}

		if (isset($this->request->post['module_websky_otp_image_fill'])) {
			$data['module_websky_otp_image_fill'] = $this->request->post['module_websky_otp_image_fill'];
		} elseif ($this->config->get('module_websky_otp_image_fill')) {
			$data['module_websky_otp_image_fill'] = $this->config->get('module_websky_otp_image_fill');
		} else {
			$data['module_websky_otp_image_fill'] = "catalog/fill.png";
		}
		if (isset($this->request->post['module_websky_otp_country'])) {
			$data['module_websky_otp_country'] = $this->request->post['module_websky_otp_country'];
		} else {
			$data['module_websky_otp_country'] = $this->config->get('module_websky_otp_country');
		}
		//print_r($data['module_websky_otp_country']);
		if (isset($this->request->post['module_websky_otp_country_header'])) {
			$data['module_websky_otp_country_header'] = $this->request->post['module_websky_otp_country_header'];
		} else {
			$data['module_websky_otp_country_header'] = $this->config->get('module_websky_otp_country_header');
		}
		if (isset($this->request->post['module_websky_otp_default_country'])) {
			$data['module_websky_otp_default_country'] = $this->request->post['module_websky_otp_default_country'];
		} elseif ($this->config->get('module_websky_otp_default_country')) {
			$data['module_websky_otp_default_country'] = $this->config->get('module_websky_otp_default_country');

		} else {
			$data['module_websky_otp_default_country'] = "IR";
		}

		if (isset($this->request->post['module_websky_otp_samane_sms'])) {
			$data['module_websky_otp_samane_sms'] = $this->request->post['module_websky_otp_samane_sms'];
		} else {
			$data['module_websky_otp_samane_sms'] = $this->config->get('module_websky_otp_samane_sms');
		}

		if (isset($this->request->post['module_websky_otp_sms_APIKey'])) {
			$data['module_websky_otp_sms_APIKey'] = $this->request->post['module_websky_otp_sms_APIKey'];
		} else {
			$data['module_websky_otp_sms_APIKey'] = $this->config->get('module_websky_otp_sms_APIKey');
		}


		if (isset($this->request->post['module_websky_otp_sms_SecretKey'])) {
			$data['module_websky_otp_sms_SecretKey'] = $this->request->post['module_websky_otp_sms_SecretKey'];
		} else {
			$data['module_websky_otp_sms_SecretKey'] = $this->config->get('module_websky_otp_sms_SecretKey');
		}

		if (isset($this->request->post['module_websky_otp_sms_from'])) {
			$data['module_websky_otp_sms_from'] = $this->request->post['module_websky_otp_sms_from'];
		} else {
			$data['module_websky_otp_sms_from'] = $this->config->get('module_websky_otp_sms_from');
		}
		if (isset($this->request->post['module_websky_otp_sms_user'])) {
			$data['module_websky_otp_sms_user'] = $this->request->post['module_websky_otp_sms_user'];
		} else {
			$data['module_websky_otp_sms_user'] = $this->config->get('module_websky_otp_sms_user');
		}
		if (isset($this->request->post['module_websky_otp_sms_pass'])) {
			$data['module_websky_otp_sms_pass'] = $this->request->post['module_websky_otp_sms_pass'];
		} else {
			$data['module_websky_otp_sms_pass'] = $this->config->get('module_websky_otp_sms_pass');
		}
		if (isset($this->request->post['module_websky_otp_web_url'])) {
			$data['module_websky_otp_web_url'] = $this->request->post['module_websky_otp_web_url'];
		} else {
			$data['module_websky_otp_web_url'] = $this->config->get('module_websky_otp_web_url');
		}


		if (isset($this->request->post['module_websky_otp_sms_send_url'])) {
			$data['module_websky_otp_sms_send_url'] = $this->request->post['module_websky_otp_sms_send_url'];
		} else {
			$data['module_websky_otp_sms_send_url'] = $this->config->get('module_websky_otp_sms_send_url');
		}

		if (isset($this->request->post['module_websky_otp_message'])) {
			$data['module_websky_otp_message'] = $this->request->post['module_websky_otp_message'];
		} else {
			$data['module_websky_otp_message'] = $this->config->get('module_websky_otp_message');
		}

        
		if (isset($this->request->post['module_websky_otp_email_subject'])) {
			$data['module_websky_otp_email_subject'] = $this->request->post['module_websky_otp_email_subject'];
		} elseif($this->config->get('module_websky_otp_email_subject')) {
			$data['module_websky_otp_email_subject'] = $this->config->get('module_websky_otp_email_subject');
		}else {
			$data['module_websky_otp_email_subject'] = '';
		
		}

		if (isset($this->request->post['module_websky_otp_email_message'])) {
			$data['module_websky_otp_email_message'] = $this->request->post['module_websky_otp_email_message'];
		} elseif($this->config->get('module_websky_otp_email_message')) {
			$data['module_websky_otp_email_message'] = $this->config->get('module_websky_otp_email_message');
		}else{
			$data['module_websky_otp_email_message'] = array(
				'1' => '
			<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <title>Static Template</title>

    <link
      href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap"
      rel="stylesheet"
    />
  </head>
  <body
    style="
      margin: 0;
      font-family: "Poppins", sans-serif;
      background: #ffffff;
      font-size: 14px;
    "
  >
    <div
      style="
        max-width: 680px;
        margin: 0 auto;
        padding: 45px 30px 60px;
        background: #f4f7ff;
        background-image: url(https://archisketch-resources.s3.ap-northeast-2.amazonaws.com/vrstyler/1661497957196_595865/email-template-background-banner);
        background-repeat: no-repeat;
        background-size: 800px 452px;
        background-position: top center;
        font-size: 14px;
        color: #434343;
      "
    >
      <header>
        <table style="width: 100%;">
          <tbody>
            <tr style="height: 0;">
              <td>
                <img
                  alt=""
                  src="'.$this->model_tool_image->resize($this->config->get('config_logo'), 100, 100).'"
                  height="30px"
                />
              </td>
              <td style="text-align: right;">
                <span
                  style="font-size: 16px; line-height: 30px; color: #ffffff;"
                  ></span
                >
              </td>
            </tr>
          </tbody>
        </table>
      </header>

      <main>
        <div
          style="
            margin: 0;
            margin-top: 70px;
            padding: 92px 30px 115px;
            background: #ffffff;
            border-radius: 30px;
            text-align: center;
          "
        >
          <div style="width: 100%; max-width: 489px; margin: 0 auto;">
            <h1
              style="
                margin: 0;
                font-size: 24px;
                font-weight: 500;
                color: #1f1f1f;
              "
            >
              Your OTP
            </h1>
            <p
              style="
                margin: 0;
                margin-top: 17px;
                font-size: 16px;
                font-weight: 500;
              "
            >
              Hey ,
            </p>
            <p
              style="
                margin: 0;
                margin-top: 17px;
                font-weight: 500;
                letter-spacing: 0.56px;
              "
            >
              Thank you for choosing my Company. Use the following OTP
              to complete the procedure to verify your email address. OTP is
              valid for
              <span style="font-weight: 600; color: #1f1f1f;">5 minutes</span>.
              Do not share this code with others, including Archisketch
              employees.
            </p>
            <p
              style="
                margin: 0;
                margin-top: 60px;
                font-size: 40px;
                font-weight: 600;
                letter-spacing: 25px;
                color: #ba3d4f;
              "
            >
             [otp]
            </p>
          </div>
        </div>

        <p
          style="
            max-width: 400px;
            margin: 0 auto;
            margin-top: 90px;
            text-align: center;
            font-weight: 500;
            color: #8c8c8c;
          "
        >
          Need help? Ask at
          <a
            href="mailto:archisketch@gmail.com"
            style="color: #499fb6; text-decoration: none;"
            >your@gmail.com</a
          >
          or visit our
          <a
            href=""
            target="_blank"
            style="color: #499fb6; text-decoration: none;"
            >Help Center</a
          >
        </p>
      </main>

      <footer
        style="
          width: 100%;
          max-width: 490px;
          margin: 20px auto 0;
          text-align: center;
          border-top: 1px solid #e6ebf1;
        "
      >
        <p
          style="
            margin: 0;
            margin-top: 40px;
            font-size: 16px;
            font-weight: 600;
            color: #434343;
          "
        >
          your Company
        </p>
        <p style="margin: 0; margin-top: 8px; color: #434343;">
          Address 540, City, State.
        </p>
        <div style="margin: 0; margin-top: 16px;">
          <a href="" target="_blank" style="display: inline-block;">
            <img
              width="36px"
              alt="Facebook"
              src=""
            />
          </a>
          <a
            href=""
            target="_blank"
            style="display: inline-block; margin-left: 8px;"
          >
            <img
              width="36px"
              alt="Instagram"
              src=""
          /></a>
          <a
            href=""
            target="_blank"
            style="display: inline-block; margin-left: 8px;"
          >
            <img
              width="36px"
              alt="Twitter"
              src=""
            />
          </a>
          <a
            href=""
            target="_blank"
            style="display: inline-block; margin-left: 8px;"
          >
            <img
              width="36px"
              alt="Youtube"
              src=""
          /></a>
        </div>
        <p style="margin: 0; margin-top: 16px; color: #434343;">
          Copyright © 2022 Company. All rights reserved.
        </p>
      </footer>
    </div>
  </body>
</html>

				',
				'2' => ' 
				<!DOCTYPE html>
 <html lang="fa-ir" dir="rtl">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta http-equiv="X-UA-Compatible" content="ie=edge" />
    <title>Static Template</title>

    <link
      href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap"
      rel="stylesheet"
    />
  </head>
  <body
    style="
      margin: 0;
      font-family: "tahoma", sans-serif;
      background: #ffffff;
      font-size: 14px;
    "
  >
    <div
      style="
        max-width: 680px;
        margin: 0 auto;
        padding: 45px 30px 60px;
        background: #f4f7ff;
        background-image: url(https://archisketch-resources.s3.ap-northeast-2.amazonaws.com/vrstyler/1661497957196_595865/email-template-background-banner);
        background-repeat: no-repeat;
        background-size: 800px 452px;
        background-position: top center;
        font-size: 14px;
        color: #434343;
      "
    >
      <header>
        <table style="width: 100%;">
          <tbody>
            <tr style="height: 0;">
              <td>
                <img
                  alt=""
                 src="'.$this->model_tool_image->resize($this->config->get('config_logo'), 100, 100).'"
                  height="30px"
                />
              </td>
              <td style="text-align: right;">
                <span
                  style="font-size: 16px; line-height: 30px; color: #ffffff;"
                  ></span
                >
              </td>
            </tr>
          </tbody>
        </table>
      </header>

      <main>
        <div
          style="
            margin: 0;
            margin-top: 70px;
            padding: 92px 30px 115px;
            background: #ffffff;
            border-radius: 30px;
            text-align: center;
          "
        >
          <div style="width: 100%; max-width: 489px; margin: 0 auto;">
            <h1
              style="
                margin: 0;
                font-size: 24px;
                font-weight: 500;
                color: #1f1f1f;
              "
            >
             کد تایید شما در سایت
            </h1>
            <p
              style="
                margin: 0;
                margin-top: 17px;
                font-size: 16px;
                font-weight: 500;
              "
            >
              سلام کاربر عزیز
            </p>
            <p
              style="
                margin: 0;
                margin-top: 17px;
                font-weight: 500;
                letter-spacing: 0.56px;
              "
            >
              با تشکر از شما برای انتخاب فروشگاه ما کد تایید شما :
            </p>
            <p
              style="
                margin: 0;
                margin-top: 60px;
                font-size: 40px;
                font-weight: 600;
                letter-spacing: 25px;
                color: #ba3d4f;
              "
            >
             [otp]
            </p>
          </div>
        </div>

        <p
          style="
            max-width: 400px;
            margin: 0 auto;
            margin-top: 90px;
            text-align: center;
            font-weight: 500;
            color: #8c8c8c;
          "
        >
        نیاز به کمک دارید به ایمیل زیر پیام بدهید
          <a
            href="mailto:your@gmail.com"
            style="color: #499fb6; text-decoration: none;"
            >your@gmail.com</a
          >
          و یا
          <a
            href=""
            target="_blank"
            style="color: #499fb6; text-decoration: none;"
            >پشتیبان</a
          >
        </p>
      </main>

      <footer
        style="
          width: 100%;
          max-width: 490px;
          margin: 20px auto 0;
          text-align: center;
          border-top: 1px solid #e6ebf1;
        "
      >
        <p
          style="
            margin: 0;
            margin-top: 40px;
            font-size: 16px;
            font-weight: 600;
            color: #434343;
          "
        >
          your Company
        </p>
        <p style="margin: 0; margin-top: 8px; color: #434343;">
          Address 540, City, State.
        </p>
        <div style="margin: 0; margin-top: 16px;">
          <a href="" target="_blank" style="display: inline-block;">
            <img
              width="36px"
              alt="Facebook"
              src=""
            />
          </a>
          <a
            href=""
            target="_blank"
            style="display: inline-block; margin-left: 8px;"
          >
            <img
              width="36px"
              alt="Instagram"
              src=""
          /></a>
          <a
            href=""
            target="_blank"
            style="display: inline-block; margin-left: 8px;"
          >
            <img
              width="36px"
              alt="Twitter"
              src=""
            />
          </a>
          <a
            href=""
            target="_blank"
            style="display: inline-block; margin-left: 8px;"
          >
            <img
              width="36px"
              alt="Youtube"
              src=""
          /></a>
        </div>
        <p style="margin: 0; margin-top: 16px; color: #434343;">
          Copyright © 2024 Company. All rights reserved.
        </p>
      </footer>
    </div>
  </body>
</html>


				'
			);
		}

		if (isset($this->request->post['module_websky_otp_test'])) {
			$data['module_websky_otp_test'] = $this->request->post['module_websky_otp_test'];
		} else {
			$data['module_websky_otp_test'] = $this->config->get('module_websky_otp_test');
		}

		if (isset($this->request->post['module_websky_otp_fill_form'])) {
			$data['module_websky_otp_fill_form'] = $this->request->post['module_websky_otp_fill_form'];
		} else {
			$data['module_websky_otp_fill_form'] = $this->config->get('module_websky_otp_fill_form');
		}

		////////////////seo //////////
		if (isset($this->request->post['module_websky_otp_seo'])) {
			$data['module_websky_otp_seo'] = $this->request->post['module_websky_otp_seo'];
		} else {
			$data['module_websky_otp_seo'] = $this->config->get('module_websky_otp_seo');
		}
		//////////////end seo/////////
		$this->load->model('localisation/country');

		$data['countries'] = $this->model_localisation_country->getCountries();



		$this->load->model('localisation/language');

		$data['languages'] = $this->model_localisation_language->getLanguages();

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		$this->load->model('setting/store');

		$data['stores'] = array();

		$data['stores'][] = array(
			'store_id' => 0,
			'name' => $this->language->get('text_default')
		);

		$stores = $this->model_setting_store->getStores();

		foreach ($stores as $store) {
			$data['stores'][] = array(
				'store_id' => $store['store_id'],
				'name' => $store['name']
			);
		}

		$this->response->setOutput($this->load->view('extension/module/websky_otp', $data));
	}

	protected function validate()
	{
		if (!$this->user->hasPermission('modify', 'extension/module/websky_otp')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if ($this->request->post['module_websky_otp_seo']) {
			$this->load->model('design/seo_url');

			foreach ($this->request->post['module_websky_otp_seo'] as $store_id => $keyword) {



				$seo_urls = $this->model_design_seo_url->getSeoUrlsByKeyword($keyword);

				foreach ($seo_urls as $seo_url) {
					if (($seo_url['store_id'] == $store_id) && ($seo_url['query'] != 'websky_otp')) {
						$this->error['keyword'][$store_id] = $this->language->get('error_keyword');

						break;
					}
				}
			}

		}




		return !$this->error;
	}



	public function install()
	{

		$col = $this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . "customer` LIKE 'sms_verify_code'");
		if (!$col->num_rows) {
			$this->db->query("
	             ALTER TABLE `" . DB_PREFIX . "customer` 
				ADD COLUMN `sms_verify_code`INT(11) NOT NULL AFTER `customer_id`  ,
				ADD COLUMN `sms_verify_status`INT(11) NOT NULL DEFAULT '0' AFTER `customer_id`  ;
	
		");	
		}
		$this->load->model('setting/event');
		if (!$this->model_setting_event->getEventByCode('edit_customer_login_verify')) {
			$this->model_setting_event->addEvent('edit_customer_login_verify', 'catalog/model/account/address/addAddress/after', 'extension/module/websky_otp/editCustomer');
		}
		if(!$this->model_setting_event->getEventByCode('edit_order_login_verify')){
			$this->model_setting_event->addEvent('edit_order_login_verify', 'catalog/model/checkout/order/addOrderHistory/before', 'extension/module/websky_otp/editOrderinfo');

		}
		$this->clear();
		$this->refresh();
		

		
	
	}

	public function refresh() {
		

		$this->load->model('setting/modification');

		if ($this->validate()) {
			// Just before files are deleted, if config settings say maintenance mode is off then turn it on
			$maintenance = $this->config->get('config_maintenance');

			$this->load->model('setting/setting');

			$this->model_setting_setting->editSettingValue('config', 'config_maintenance', true);

			//Log
			$log = array();

			// Clear all modification files
			$files = array();

			// Make path into an array
			$path = array(DIR_MODIFICATION . '*');

			// While the path array is still populated keep looping through
			while (count($path) != 0) {
				$next = array_shift($path);

				foreach (glob($next) as $file) {
					// If directory add to path array
					if (is_dir($file)) {
						$path[] = $file . '/*';
					}

					// Add the file to the files to be deleted array
					$files[] = $file;
				}
			}

			// Reverse sort the file array
			rsort($files);

			// Clear all modification files
			foreach ($files as $file) {
				if ($file != DIR_MODIFICATION . 'index.html') {
					// If file just delete
					if (is_file($file)) {
						unlink($file);

					// If directory use the remove directory function
					} elseif (is_dir($file)) {
						rmdir($file);
					}
				}
			}

			// Begin
			$xml = array();

			// Load the default modification XML
			$xml[] = file_get_contents(DIR_SYSTEM . 'modification.xml');

			// This is purly for developers so they can run mods directly and have them run without upload after each change.
			$files = glob(DIR_SYSTEM . '*.ocmod.xml');

			if ($files) {
				foreach ($files as $file) {
					$xml[] = file_get_contents($file);
				}
			}

			// Get the default modification file
			$results = $this->model_setting_modification->getModifications();

			foreach ($results as $result) {
				if ($result['status']) {
					$xml[] = $result['xml'];
				}
			}

			$modification = array();

			foreach ($xml as $xml) {
				if (empty($xml)){
					continue;
				}
				
				$dom = new DOMDocument('1.0', 'UTF-8');
				$dom->preserveWhiteSpace = false;
				$dom->loadXml($xml);

				// Log
				$log[] = 'MOD: ' . $dom->getElementsByTagName('name')->item(0)->textContent;

				// Wipe the past modification store in the backup array
				$recovery = array();

				// Set the a recovery of the modification code in case we need to use it if an abort attribute is used.
				if (isset($modification)) {
					$recovery = $modification;
				}

				$files = $dom->getElementsByTagName('modification')->item(0)->getElementsByTagName('file');

				foreach ($files as $file) {
					$operations = $file->getElementsByTagName('operation');

					$files = explode('|', $file->getAttribute('path'));

					foreach ($files as $file) {
						$path = '';

						// Get the full path of the files that are going to be used for modification
						if ((substr($file, 0, 7) == 'catalog')) {
							$path = DIR_CATALOG . substr($file, 8);
						}

						if ((substr($file, 0, 5) == 'admin')) {
							$path = DIR_APPLICATION . substr($file, 6);
						}

						if ((substr($file, 0, 6) == 'system')) {
							$path = DIR_SYSTEM . substr($file, 7);
						}

						if ($path) {
							$files = glob($path, GLOB_BRACE);

							if ($files) {
								foreach ($files as $file) {
									// Get the key to be used for the modification cache filename.
									if (substr($file, 0, strlen(DIR_CATALOG)) == DIR_CATALOG) {
										$key = 'catalog/' . substr($file, strlen(DIR_CATALOG));
									}

									if (substr($file, 0, strlen(DIR_APPLICATION)) == DIR_APPLICATION) {
										$key = 'admin/' . substr($file, strlen(DIR_APPLICATION));
									}

									if (substr($file, 0, strlen(DIR_SYSTEM)) == DIR_SYSTEM) {
										$key = 'system/' . substr($file, strlen(DIR_SYSTEM));
									}

									// If file contents is not already in the modification array we need to load it.
									if (!isset($modification[$key])) {
										$content = file_get_contents($file);

										$modification[$key] = preg_replace('~\r?\n~', "\n", $content);
										$original[$key] = preg_replace('~\r?\n~', "\n", $content);

										// Log
										$log[] = PHP_EOL . 'FILE: ' . $key;
									}

									foreach ($operations as $operation) {
										$error = $operation->getAttribute('error');

										// Ignoreif
										$ignoreif = $operation->getElementsByTagName('ignoreif')->item(0);

										if ($ignoreif) {
											if ($ignoreif->getAttribute('regex') != 'true') {
												if (strpos($modification[$key], $ignoreif->textContent) !== false) {
													continue;
												}
											} else {
												if (preg_match($ignoreif->textContent, $modification[$key])) {
													continue;
												}
											}
										}

										$status = false;

										// Search and replace
										if ($operation->getElementsByTagName('search')->item(0)->getAttribute('regex') != 'true') {
											// Search
											$search = $operation->getElementsByTagName('search')->item(0)->textContent;
											$trim = $operation->getElementsByTagName('search')->item(0)->getAttribute('trim');
											$index = $operation->getElementsByTagName('search')->item(0)->getAttribute('index');

											// Trim line if no trim attribute is set or is set to true.
											if (!$trim || $trim == 'true') {
												$search = trim($search);
											}

											// Add
											$add = $operation->getElementsByTagName('add')->item(0)->textContent;
											$trim = $operation->getElementsByTagName('add')->item(0)->getAttribute('trim');
											$position = $operation->getElementsByTagName('add')->item(0)->getAttribute('position');
											$offset = $operation->getElementsByTagName('add')->item(0)->getAttribute('offset');

											if ($offset == '') {
												$offset = 0;
											}

											// Trim line if is set to true.
											if ($trim == 'true') {
												$add = trim($add);
											}

											// Log
											$log[] = 'CODE: ' . $search;

											// Check if using indexes
											if ($index !== '') {
												$indexes = explode(',', $index);
											} else {
												$indexes = array();
											}

											// Get all the matches
											$i = 0;

											$lines = explode("\n", $modification[$key]);

											for ($line_id = 0; $line_id < count($lines); $line_id++) {
												$line = $lines[$line_id];

												// Status
												$match = false;

												// Check to see if the line matches the search code.
												if (stripos($line, $search) !== false) {
													// If indexes are not used then just set the found status to true.
													if (!$indexes) {
														$match = true;
													} elseif (in_array($i, $indexes)) {
														$match = true;
													}

													$i++;
												}

												// Now for replacing or adding to the matched elements
												if ($match) {
													switch ($position) {
														default:
														case 'replace':
															$new_lines = explode("\n", $add);

															if ($offset < 0) {
																array_splice($lines, $line_id + $offset, abs($offset) + 1, array(str_replace($search, $add, $line)));

																$line_id -= $offset;
															} else {
																array_splice($lines, $line_id, $offset + 1, array(str_replace($search, $add, $line)));
															}
															break;
														case 'before':
															$new_lines = explode("\n", $add);

															array_splice($lines, $line_id - $offset, 0, $new_lines);

															$line_id += count($new_lines);
															break;
														case 'after':
															$new_lines = explode("\n", $add);

															array_splice($lines, ($line_id + 1) + $offset, 0, $new_lines);

															$line_id += count($new_lines);
															break;
													}

													// Log
													$log[] = 'LINE: ' . $line_id;

													$status = true;
												}
											}

											$modification[$key] = implode("\n", $lines);
										} else {
											$search = trim($operation->getElementsByTagName('search')->item(0)->textContent);
											$limit = $operation->getElementsByTagName('search')->item(0)->getAttribute('limit');
											$replace = trim($operation->getElementsByTagName('add')->item(0)->textContent);

											// Limit
											if (!$limit) {
												$limit = -1;
											}

											// Log
											$match = array();

											preg_match_all($search, $modification[$key], $match, PREG_OFFSET_CAPTURE);

											// Remove part of the the result if a limit is set.
											if ($limit > 0) {
												$match[0] = array_slice($match[0], 0, $limit);
											}

											if ($match[0]) {
												$log[] = 'REGEX: ' . $search;

												for ($i = 0; $i < count($match[0]); $i++) {
													$log[] = 'LINE: ' . (substr_count(substr($modification[$key], 0, $match[0][$i][1]), "\n") + 1);
												}

												$status = true;
											}

											// Make the modification
											$modification[$key] = preg_replace($search, $replace, $modification[$key], $limit);
										}

										if (!$status) {
											// Abort applying this modification completely.
											if ($error == 'abort') {
												$modification = $recovery;
												// Log
												$log[] = 'NOT FOUND - ABORTING!';
												break 5;
											}
											// Skip current operation or break
											elseif ($error == 'skip') {
												// Log
												$log[] = 'NOT FOUND - OPERATION SKIPPED!';
												continue;
											}
											// Break current operations
											else {
												// Log
												$log[] = 'NOT FOUND - OPERATIONS ABORTED!';
											 	break;
											}
										}
									}
								}
							}
						}
					}
				}

				// Log
				$log[] = '----------------------------------------------------------------';
			}

			// Log
			$ocmod = new Log('ocmod.log');
			$ocmod->write(implode("\n", $log));

			// Write all modification files
			foreach ($modification as $key => $value) {
				// Only create a file if there are changes
				if ($original[$key] != $value) {
					$path = '';

					$directories = explode('/', dirname($key));

					foreach ($directories as $directory) {
						$path = $path . '/' . $directory;

						if (!is_dir(DIR_MODIFICATION . $path)) {
							@mkdir(DIR_MODIFICATION . $path, 0777);
						}
					}

					$handle = fopen(DIR_MODIFICATION . $key, 'w');

					fwrite($handle, $value);

					fclose($handle);
				}
			}

			// Maintance mode back to original settings
			$this->model_setting_setting->editSettingValue('config', 'config_maintenance', $maintenance);


		}

		
	}

	public function clear() {
		


		$this->load->model('setting/modification');

		if ($this->validate()) {
			$files = array();

			// Make path into an array
			$path = array(DIR_MODIFICATION . '*');

			// While the path array is still populated keep looping through
			while (count($path) != 0) {
				$next = array_shift($path);

				foreach (glob($next) as $file) {
					// If directory add to path array
					if (is_dir($file)) {
						$path[] = $file . '/*';
					}

					// Add the file to the files to be deleted array
					$files[] = $file;
				}
			}

			// Reverse sort the file array
			rsort($files);

			// Clear all modification files
			foreach ($files as $file) {
				if ($file != DIR_MODIFICATION . 'index.html') {
					// If file just delete
					if (is_file($file)) {
						unlink($file);

					// If directory use the remove directory function
					} elseif (is_dir($file)) {
						rmdir($file);
					}
				}
			}

			}

		
	}

	public function test_sms()
	{
		$code = rand(1000, 10000);
		$telephone = $this->request->post['telephone'];
		$data['user_token'] = $this->session->data['user_token'];
		require_once(DIR_SYSTEM . 'library/sms/otp.php');
		$this->otp = new Otp();


		$websky_otp_message = $this->config->get("module_websky_otp_message");
		$message = $websky_otp_message[$this->config->get('config_language_id')];
		$verify_message = str_replace("[otp]", $code, $message);
		$input_data = array("verification-code" => $code);

		if ($this->config->get("module_websky_otp_samane_sms") == 'smsir' || $this->config->get("module_websky_otp_samane_sms") == 'twilio') {
			$user = $this->config->get('module_websky_otp_sms_APIKey');
			$pass = $this->config->get('module_websky_otp_sms_SecretKey');
		} elseif ($this->config->get("module_websky_otp_samane_sms") == 'sabanovin') {
			$user = $this->config->get('module_websky_otp_sms_APIKey');
			$pass = $this->config->get('module_websky_otp_sms_APIKey');
		} else {
			$user = $this->config->get('module_websky_otp_sms_user');
			$pass = $this->config->get('module_websky_otp_sms_pass');
		}
		$from = $this->config->get('module_websky_otp_sms_from');
		$pattern_code = $this->config->get('module_websky_otp_paterncode');
		if (isset($pattern_code[$this->config->get("module_websky_otp_samane_sms")])) {
			$pattern_code_samane = $pattern_code[$this->config->get("module_websky_otp_samane_sms")];
		} else {
			$pattern_code_samane = 0;
		}
		if ($this->config->get("module_websky_otp_samane_sms") == 'melipayamak') {
			$input_data = $code;
			$from[$this->config->get("module_websky_otp_samane_sms")] = '';
		}
		if ($this->config->get("module_websky_otp_samane_sms") == 'smartwhatsapp') {
			$from[$this->config->get("module_websky_otp_samane_sms")] = '';
		}
		if ($this->config->get("module_websky_otp_samane_sms") == 'sendurl') {
			$input_data = $this->config->get("module_websky_otp_sms_send_url");
			$from[$this->config->get("module_websky_otp_samane_sms")] = '';
			$user[$this->config->get("module_websky_otp_samane_sms")]='';
			$pass[$this->config->get("module_websky_otp_samane_sms")]='';
		}

          
		if (isset($this->request->post['module_websky_otp_sms_send_url'])) {
			$data['module_websky_otp_sms_send_url'] = $this->request->post['module_websky_otp_sms_send_url'];
		} else {
			$data['module_websky_otp_sms_send_url'] = $this->config->get('module_websky_otp_sms_send_url');
		}

		
		$json = array();
		$json['result'] = $this->otp->send($telephone, $verify_message, $user[$this->config->get("module_websky_otp_samane_sms")], $pass[$this->config->get("module_websky_otp_samane_sms")], $this->config->get('module_websky_otp_samane_sms'), $from[$this->config->get("module_websky_otp_samane_sms")], 'pattern', $pattern_code_samane, $input_data);


		$json['success'] = true;
		$this->response->setOutput(json_encode($json));
	}



}