<?php

require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLoader.php';
require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLibrary.php';

class ControllerExtensionPaymentMyfatoorahPg extends Controller {

    private $mfCode = 'myfatoorah_pg';
    private $model  = 'payment';
    private $errors, $warnings, $isActive;
    private $mfObj, $mfConfig;
    private $oc;
    private $fields = [
        'status', 'sort_order', 'debug',
        'apiKey', 'countryMode', 'test',
        'payment_type', 'saveCard', 'webhook_secret_key',
        'initial_order_status_id', 'order_status_id', 'failed_order_status_id',
        'isApplePayRegistered', 'supplierCode'
    ];

//-----------------------------------------------------------------------------------------------------------------------------------------
    public function __construct($registry) {
        parent::__construct($registry);
        $this->oc = $this->getOpenCartVersionInfo();
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    public function uninstall() {
        //disable MyFatoorah shipping too if the MyFatoorah payment is uninstalled
        $this->load->model('setting/setting');
        $this->model_setting_setting->{$this->oc['editSettingFun']}($this->oc['shippingCode'], $this->oc['shippingCode'] . '_status', 0);
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    public function order() {

        if (empty($this->request->get['order_id'])) {
            return '';
        }
        $orderId = (int) $this->request->get['order_id'];

        //check for the payment_custom_field
        $this->load->model('sale/order');
        $order = $this->model_sale_order->getOrder($orderId);
        $data  = $order['payment_custom_field'];

        if (!empty($data['invoiceURL'])) {
            $link = empty($data['paymentId']) ? $data['invoiceURL'] : MyFatoorah::getPaymentStatusLink($data['invoiceURL'], $data['paymentId']);

            $msg = 'MyFatoorah Invoice Details:</b><br> Invoice ID: ' . $data['invoiceId'] . '<br>';
            $msg .= 'Payment URL: <a href ="' . $link . '" target="_blank">' . $link . '</a>';

            return $msg;
        }

        //to be compatible with the old version history
        $this->load->model($this->oc['path']);
        $results = $this->{$this->oc['paymentModel']}->getHistories($orderId);

        $comments = array_column($results, 'comment');
        $array    = array_filter($comments); //to remove empty data 
        $imploded = implode('<br><br>', $array);

        return $imploded;
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    public function index() {
        //Load language
        $data = $this->language->load($this->oc['path']);

        $data['mfVersion'] = '2.2.0';
        $data['ocCode']    = $this->oc['ocCode'];

        //Set document title
        $this->document->setTitle($this->language->get('heading_title'));

        //If POST reques, change settings
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->save();
            $data['success'] = $this->language->get('text_success');
        }

        $data['errors']   = $this->errors;
        $data['warnings'] = $this->warnings;

        //Load action buttons urls
        $data['action'] = $this->url->link($this->oc['path'], $this->oc['token'], true);
        $data['cancel'] = $this->url->link($this->oc['link'], $this->oc['token'], true);

        //Load breadcrumbs
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', $this->oc['token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $data['cancel']
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $data['action']
        );

        //Set default values for fields
        $this->getFieldsValues($data);

        //Lookups
        $this->load->model('localisation/order_status');
        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();
        array_unshift($data['order_statuses'], array('order_status_id' => 0, 'name' => $this->language->get('missing_order')));

        $data['mfCountries'] = MyFatoorah::getMFCountries();
        $data['nameIndex']   = 'countryName' . ucfirst($this->language->get('code'));

        //Load default layout, must be in the end
        $data['header']      = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer']      = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view($this->oc['view'], $data));
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function validate() {

        $this->isActive = !empty($this->request->post[$this->oc['ocCode'] . '_status']);
        if (!$this->isActive) {
            return true;
        }

        $apiKey = trim($this->request->post[$this->oc['ocCode'] . '_apiKey']);
        if (!$apiKey) {
            $this->errors['danger'] = $this->errors['apiKey'] = $this->language->get('error_apiKey');
            return false;
        }

        $this->mfConfig = [
            'apiKey'     => $apiKey,
            'isTest'     => !empty($this->request->post[$this->oc['ocCode'] . '_test']),
            'vcCode'     => $this->request->post[$this->oc['ocCode'] . '_countryMode'],
            'loggerObj'  => new Log($this->mfCode . '.log'),
            'loggerFunc' => 'write'
        ];

        $this->mfObj = new MyFatoorahPayment($this->mfConfig);
        try {
            $this->mfObj->initiatePayment();
            return true;
        } catch (Exception $ex) {
            $this->errors['danger'] = $this->errors['apiKey'] = $this->errors['isTest'] = $this->errors['vcCode'] = $ex->getMessage();
            return false;
        }
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function save() {

        if (file_exists(MyFatoorahPayment::$pmCachedFile)) {
            unlink(MyFatoorahPayment::$pmCachedFile);
        }

        if (!is_numeric($this->request->post[$this->oc['ocCode'] . '_sort_order'])) {
            $this->request->post[$this->oc['ocCode'] . '_sort_order'] = $this->config->get($this->oc['ocCode'] . '_sort_order');
        }

        if (!$this->registerApplePay($this->oc['ocCode'])) {
            $this->request->post[$this->oc['ocCode'] . '_isApplePayRegistered'] = 0;
        }

        if (!$this->registerSupplier($this->oc['ocCode'])) {
            $this->request->post[$this->oc['ocCode'] . '_supplierCode'] = '';
        }

        //Edit settings
        $this->load->model('setting/setting');
        $this->model_setting_setting->editSetting($this->oc['ocCode'], $this->request->post);

        //disable MyFatoorah shipping too if the MyFatoorah payment is disable
        if (!$this->isActive) {
            $this->model_setting_setting->{$this->oc['editSettingFun']}($this->oc['shippingCode'], $this->oc['shippingCode'] . '_status', 0);
        }
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function registerApplePay() {

        $isApReg = $this->request->post[$this->oc['ocCode'] . '_isApplePayRegistered'];
        if (!$this->isActive || !$isApReg) {
            return true;
        }

        //check list option
        if ($this->request->post[$this->oc['ocCode'] . '_payment_type'] == 'myfatoorah') {
            $this->warnings[] = $this->language->get('warning_applePay_listOption');
            return false;
        }

        //register
        $url = defined('HTTPS_SERVER') ? HTTPS_SERVER : HTTP_SERVER;
        try {
            $mfData = $this->mfObj->registerApplePayDomain($url);
            //if ($mfData->Message == 'OK') {
                return true;
            //}

            //$this->warnings[] = $this->language->get('warning_applePay_register') . $mfData->Message;
        } catch (Exception $ex) {
            $this->warnings[] = $this->language->get('warning_applePay_register') . $ex->getMessage();
        }
        return false;
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function registerSupplier() {

        $supplierCode = $this->request->post[$this->oc['ocCode'] . '_supplierCode'];
        if (!$this->isActive || empty($supplierCode)) {
            return true;
        }

        if (!is_numeric($supplierCode)) {
            $this->warnings[] = $this->language->get('warning_supplierCode_numeric');
            return false;
        }

        try {
            $mfObj = new MyFatoorahSupplier($this->mfConfig);
            if ($mfObj->isSupplierApproved($supplierCode)) {
                return true;
            }

            $this->warnings[] = $this->language->get('warning_supplierCode_activation');
        } catch (Exception $ex) {
            $this->warnings[] = $this->language->get('warning_supplierCode') . $ex->getMessage();
        }
        return false;
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function getFieldsValues(&$data) {
        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            foreach ($this->fields as $field) {
                $key          = $this->oc['ocCode'] . '_' . $field;
                $data[$field] = $this->request->post[$key] ?? '';
            }
        } else {
            foreach ($this->fields as $field) {
                $key          = $this->oc['ocCode'] . '_' . $field;
                $data[$field] = $this->config->get($key);
            }

            //1st time installation
            if (!$this->config->has($this->oc['ocCode'] . '_sort_order')) {
                $data['sort_order'] = 0;
                $data['debug']      = 1;

                //Default values for select status
                $data['initial_order_status_id'] = 0;
                $data['order_status_id']         = 2;
                $data['failed_order_status_id']  = 10;
            }
        }
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function getOpenCartVersionInfo() {

        //-----------------------------------------
        if (version_compare(VERSION, '4.0', '>=')) {
            return[
                'path'           => "extension/myfatoorah/$this->model/$this->mfCode",
                'view'           => "extension/myfatoorah/$this->model/$this->mfCode",
                'token'          => 'user_token=' . $this->session->data['user_token'],
                'link'           => 'marketplace/extension&type=' . $this->model,
                'ocCode'         => $this->model . '_' . $this->mfCode,
                'shippingCode'   => 'shipping_myfatoorah',
                'editSettingFun' => 'editValue',
                'paymentModel'   => "model_extension_myfatoorah_payment_$this->mfCode",
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '3.0', '>=')) {
            return[
                'path'           => "extension/$this->model/$this->mfCode",
                'view'           => "extension/$this->model/$this->mfCode",
                'token'          => 'user_token=' . $this->session->data['user_token'],
                'link'           => 'marketplace/extension&type=' . $this->model,
                'ocCode'         => $this->model . '_' . $this->mfCode,
                'shippingCode'   => 'shipping_myfatoorah',
                'editSettingFun' => 'editSettingValue',
                'paymentModel'   => "model_extension_payment_$this->mfCode",
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '2.3', '>=')) {
            return[
                'path'           => "extension/$this->model/$this->mfCode",
                'view'           => "extension/$this->model/$this->mfCode",
                'token'          => 'token=' . $this->session->data['token'],
                'link'           => 'extension/extension&type=' . $this->model,
                'ocCode'         => $this->mfCode,
                'shippingCode'   => 'myfatoorah',
                'editSettingFun' => 'editSettingValue',
                'paymentModel'   => "model_extension_payment_$this->mfCode",
            ];
        }

        //-----------------------------------------
        return[
            'path'           => "$this->model/$this->mfCode",
            'view'           => "$this->model/$this->mfCode.tpl",
            'token'          => 'token=' . $this->session->data['token'],
            'link'           => "extension/$this->model",
            'ocCode'         => $this->mfCode,
            'shippingCode'   => 'myfatoorah',
            'editSettingFun' => 'editSettingValue',
            'paymentModel'   => "model_payment_$this->mfCode",
        ];
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
}
