<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

class ControllerExtensionPaymentPaylink extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('extension/payment/paylink');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->model_setting_setting->editSetting('payment_paylink', $this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
        }

        if (isset($this->error['warning'])) {
            $data['error_warning'] = $this->error['warning'];
        } else {
            $data['error_warning'] = '';
        }

        if (isset($this->error['app_id'])) {
            $data['error_app_id'] = $this->error['app_id'];
        } else {
            $data['error_app_id'] = '';
        }

        if (isset($this->error['secret_key'])) {
            $data['error_secret_key'] = $this->error['secret_key'];
        } else {
            $data['error_secret_key'] = '';
        }

        if (isset($this->error['mch_id'])) {
            $data['error_mch_id'] = $this->error['mch_id'];
        } else {
            $data['error_mch_id'] = '';
        }

        if (isset($this->error['api_secret'])) {
            $data['error_api_secret'] = $this->error['api_secret'];
        } else {
            $data['error_api_secret'] = '';
        }

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/payment/paylink', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/payment/paylink', 'user_token=' . $this->session->data['user_token'], true);

        $data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

        if (isset($this->request->post['payment_paylink_app_id'])) {
            $data['payment_paylink_app_id'] = $this->request->post['payment_paylink_app_id'];
        } else {
            $data['payment_paylink_app_id'] = $this->config->get('payment_paylink_app_id');
        }

        if (isset($this->request->post['payment_paylink_secret_key'])) {
            $data['payment_paylink_secret_key'] = $this->request->post['payment_paylink_secret_key'];
        } else {
            $data['payment_paylink_secret_key'] = $this->config->get('payment_paylink_secret_key');
        }


        if (isset($this->request->post['payment_paylink_total'])) {
            $data['payment_paylink_total'] = $this->request->post['payment_paylink_total'];
        } else {
            $data['payment_paylink_total'] = $this->config->get('payment_paylink_total');
        }

        if (isset($this->request->post['payment_paylink_currency'])) {
            $data['payment_paylink_currency'] = $this->request->post['payment_paylink_currency'];
        } else {
            $data['payment_paylink_currency'] = $this->config->get('payment_paylink_currency');
        }

        if (isset($this->request->post['payment_paylink_paid_status_id'])) {
            $data['payment_paylink_paid_status_id'] = $this->request->post['payment_paylink_paid_status_id'];
        } else {
            $data['payment_paylink_paid_status_id'] = $this->config->get('payment_paylink_paid_status_id');
        }


        if (isset($this->request->post['payment_paylink_declined_status_id'])) {
            $data['payment_paylink_declined_status_id'] = $this->request->post['payment_paylink_declined_status_id'];
        } else {
            $data['payment_paylink_declined_status_id'] = $this->config->get('payment_paylink_declined_status_id');
        }


        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        if (isset($this->request->post['payment_paylink_geo_zone_id'])) {
            $data['payment_paylink_geo_zone_id'] = $this->request->post['payment_paylink_geo_zone_id'];
        } else {
            $data['payment_paylink_geo_zone_id'] = $this->config->get('payment_paylink_geo_zone_id');
        }

        $this->load->model('localisation/geo_zone');

        $data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();

        if (isset($this->request->post['payment_paylink_status'])) {
            $data['payment_paylink_status'] = $this->request->post['payment_paylink_status'];
        } else {
            $data['payment_paylink_status'] = $this->config->get('payment_paylink_status');
        }

        if (isset($this->request->post['payment_paylink_testmode'])) {
            $data['payment_paylink_testmode'] = $this->request->post['payment_paylink_testmode'];
        } else {
            $data['payment_paylink_testmode'] = $this->config->get('payment_paylink_testmode');
        }

        if (isset($this->request->post['payment_paylink_sort_order'])) {
            $data['payment_paylink_sort_order'] = $this->request->post['payment_paylink_sort_order'];
        } else {
            $data['payment_paylink_sort_order'] = $this->config->get('payment_paylink_sort_order');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/paylink', $data));
    }

    private function validate()
    {
        if (!$this->user->hasPermission('modify', 'extension/payment/paylink')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['payment_paylink_app_id']) {
            $this->error['app_id'] = $this->language->get('error_app_id');
        }

        if (!$this->request->post['payment_paylink_secret_key']) {
            $this->error['secret_key'] = $this->language->get('error_secret_key');
        }

        return !$this->error;
    }

    public function install()
    {
        $this->load->model('setting/setting');
        $data = array(
            'payment_paylink_app_id' => 'APP_ID_1123453311',
            'payment_paylink_secret_key' => '0662abb5-13c7-38ab-cd12-236e58f43766',

            'payment_paylink_currency' => 'SAR',
            'payment_paylink_total' => 5,
            'payment_paylink_testmode' => 1,

            'payment_paylink_paid_status_id' => 5,
            'payment_paylink_declined_status_id' => 8,

            'payment_paylink_geo_zone_id' => 0,
            'payment_paylink_sort_order' => 1,
        );
        $this->model_setting_setting->editSetting('payment_paylink', $data);
    }

    public function uninstall()
    {
        $this->load->model('setting/setting');

        $this->model_setting_setting->deleteSetting('payment_paylink');

    }

}

