<?php
class ControllerExtensionPaymentThawani extends Controller
{
    private $error = array();

    public function index()
    {
        $this->load->language('extension/payment/thawani');

        $this->document->setTitle($this->language->get('heading_title'));

        $this->load->model('setting/setting');

        if(($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate())
        {
            $this->model_setting_setting->editSetting('payment_thawani', $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
        }

        $data['heading_title'] = $this->language->get('heading_title');

        $data['text_edit'] = $this->language->get('text_edit');
        $data['text_enabled'] = $this->language->get('text_enabled');
        $data['text_disabled'] = $this->language->get('text_disabled');

        $data['entry_order_status'] = $this->language->get('entry_order_status');
        $data['entry_sort_order'] = $this->language->get('entry_sort_order');
        $data['entry_status'] = $this->language->get('entry_status');
        $data['entry_publishable_key'] = $this->language->get('entry_publishable_key');
        $data['entry_secret_key'] = $this->language->get('entry_secret_key');
        $data['entry_environment'] = $this->language->get('entry_environment');
        $data['entry_total'] = $this->language->get('entry_total');
        $data['help_total'] = $this->language->get('help_total');
        $data['entry_geo_zone'] = $this->language->get('entry_geo_zone');


        $data['button_save'] = $this->language->get('button_save');
        $data['button_cancel'] = $this->language->get('button_cancel');

        $data['breadcrumbs'] = array();
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_payment'),
            'href' => $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $this->url->link('extension/payment/thawani', 'user_token=' . $this->session->data['user_token'], true)
        );

        $data['action'] = $this->url->link('extension/payment/thawani', 'user_token=' . $this->session->data['user_token'], true);

        $data['cancel'] = $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);


        if (isset($this->request->post['payment_thawani_publishable_key']))
            $data['payment_thawani_publishable_key'] = $this->request->post['payment_thawani_publishable_key'];
        else
            $data['payment_thawani_publishable_key'] = $this->config->get('payment_thawani_publishable_key');
        
        if (isset($this->request->post['payment_thawani_secret_key']))
            $data['payment_thawani_secret_key'] = $this->request->post['payment_thawani_secret_key'];
        else
            $data['payment_thawani_secret_key'] = $this->config->get('payment_thawani_secret_key');

        if (isset($this->request->post['payment_thawani_total']))
            $data['payment_thawani_total'] = $this->request->post['payment_thawani_total'];
        else
            $data['payment_thawani_total'] = $this->config->get('payment_thawani_total'); 
            
            
        if (isset($this->request->post['payment_thawani_geo_zone_id'])) {
			$data['payment_thawani_geo_zone_id'] = $this->request->post['payment_thawani_geo_zone_id'];
		} else {
			$data['payment_thawani_geo_zone_id'] = $this->config->get('payment_thawani_geo_zone_id');
		}

		$this->load->model('localisation/geo_zone');

		$data['geo_zones'] = $this->model_localisation_geo_zone->getGeoZones();    

        if (isset($this->request->post['payment_thawani_test']))
            $data['payment_thawani_test'] = $this->request->post['payment_thawani_test'];
        else
            $data['payment_thawani_test'] = $this->config->get('payment_thawani_test');

        if(isset($this->request->post['payment_thawani_order_status_id']))
            $data['payment_thawani_order_status_id'] = $this->request->post['payment_thawani_order_status_id'];
        else
            $data['payment_thawani_order_status_id'] = $this->config->get('payment_thawani_order_status_id');

        $this->load->model('localisation/order_status');

        $data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        if (isset($this->request->post['payment_thawani_sort_order'])) {
            $data['payment_thawani_sort_order'] = $this->request->post['payment_thawani_sort_order'];
        } else {
            $data['payment_thawani_sort_order'] = $this->config->get('payment_thawani_sort_order');
        }

        if (isset($this->request->post['payment_thawani_status'])) {
                $data['payment_thawani_status'] = $this->request->post['payment_thawani_status'];
        } else {
                $data['payment_thawani_status'] = $this->config->get('payment_thawani_status');
        }

        $data['header'] = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer'] = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view('extension/payment/thawani', $data));
    }

    protected function validate() {
        if (!$this->user->hasPermission('modify', 'extension/payment/thawani')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        return !$this->error;
    }
}