<?php

class ControllerExtensionShippingMyfatoorah extends Controller {

    private $mfCode = 'myfatoorah';
    private $model  = 'shipping';
    private $errors, $warnings, $isActive;
    private $oc;
    private $fields = [
        'status', 'sort_order', 'debug',
        'shipping'
    ];

//-----------------------------------------------------------------------------------------------------------------------------------------
    public function __construct($registry) {
        parent::__construct($registry);
        $this->oc = $this->getOpenCartVersionInfo();
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    public function index() {
        //Load language
        $data = $this->language->load($this->oc['path']);

        $data['mfVersion'] = '2.2.0';
        $data['ocCode']    = $this->oc['ocCode'];

        //Set document title
        $this->document->setTitle($this->language->get('heading_title'));

        //If POST reques, change settings
        if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
            $this->save();
            $data['success'] = $this->language->get('text_success');
        }

        $data['errors']   = $this->errors;
        $data['warnings'] = $this->warnings;

        //Load action buttons urls
        $data['action'] = $this->url->link($this->oc['path'], $this->oc['token'], true);
        $data['cancel'] = $this->url->link($this->oc['link'], $this->oc['token'], true);

        //Load breadcrumbs
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/dashboard', $this->oc['token'], true)
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_extension'),
            'href' => $data['cancel']
        );
        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('heading_title'),
            'href' => $data['action']
        );

        //Set default values for fields
        $this->getFieldsValues($data);

        //Lookups
        $data['shippingMethods'] = [
            '1' => $this->language->get('text_dhl'),
            '2' => $this->language->get('text_aramex')
        ];

        //Load default layout, must be in the end
        $data['header']      = $this->load->controller('common/header');
        $data['column_left'] = $this->load->controller('common/column_left');
        $data['footer']      = $this->load->controller('common/footer');

        $this->response->setOutput($this->load->view($this->oc['view'], $data));
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function validate() {

        $this->isActive = !empty($this->request->post[$this->oc['ocCode'] . '_status']);
        if (!$this->isActive) {
            return true;
        }

        if (empty($this->config->get($this->oc['paymentStatus']))) {
            $this->errors['danger'] = $this->errors['status'] = $this->language->get('error_status');
            return false;
        }

        if (empty($this->request->post[$this->oc['ocCode'] . '_shipping'])) {
            $this->errors['danger'] = $this->errors['method'] = $this->language->get('error_method');
            return false;
        }

        return true;
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function save() {

        if (!is_numeric($this->request->post[$this->oc['ocCode'] . '_sort_order'])) {
            $this->request->post[$this->oc['ocCode'] . '_sort_order'] = $this->config->get($this->oc['ocCode'] . '_sort_order');
        }

        //Edit settings
        $this->load->model('setting/setting');
        $this->model_setting_setting->editSetting($this->oc['ocCode'], $this->request->post);
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function getFieldsValues(&$data) {
        if ($this->request->server['REQUEST_METHOD'] == 'POST') {
            foreach ($this->fields as $field) {
                $key          = $this->oc['ocCode'] . '_' . $field;
                $data[$field] = $this->request->post[$key] ?? '';
            }
        } else {
            foreach ($this->fields as $field) {
                $key          = $this->oc['ocCode'] . '_' . $field;
                $data[$field] = $this->config->get($key);
            }

            //1st time installation
            if (!$this->config->has($this->oc['ocCode'] . '_sort_order')) {
                $data['sort_order'] = 0;
                $data['debug']      = 1;
            }
        }
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function getOpenCartVersionInfo() {

        //-----------------------------------------
        if (version_compare(VERSION, '4.0', '>=')) {
            return[
                'path'          => "extension/myfatoorah/$this->model/$this->mfCode",
                'view'          => "extension/myfatoorah/$this->model/$this->mfCode",
                'token'         => 'user_token=' . $this->session->data['user_token'],
                'link'          => 'marketplace/extension&type=' . $this->model,
                'ocCode'        => $this->model . '_' . $this->mfCode,
                'paymentStatus' => 'payment_myfatoorah_pg_status',
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '3.0', '>=')) {
            return[
                'path'          => "extension/$this->model/$this->mfCode",
                'view'          => "extension/$this->model/$this->mfCode",
                'token'         => 'user_token=' . $this->session->data['user_token'],
                'link'          => 'marketplace/extension&type=' . $this->model,
                'ocCode'        => $this->model . '_' . $this->mfCode,
                'paymentStatus' => 'payment_myfatoorah_pg_status',
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '2.3', '>=')) {
            return[
                'path'          => "extension/$this->model/$this->mfCode",
                'view'          => "extension/$this->model/$this->mfCode",
                'token'         => 'token=' . $this->session->data['token'],
                'link'          => 'extension/extension&type=' . $this->model,
                'ocCode'        => $this->mfCode,
                'paymentStatus' => 'myfatoorah_pg_status',
            ];
        }

        //-----------------------------------------
        return[
            'path'          => "$this->model/$this->mfCode",
            'view'          => "$this->model/$this->mfCode.tpl",
            'token'         => 'token=' . $this->session->data['token'],
            'link'          => "extension/$this->model",
            'ocCode'        => $this->mfCode,
            'paymentStatus' => 'myfatoorah_pg_status',
        ];
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
}
