<?php
require_once DIR_SYSTEM . 'library/lbt/trait_lbt_customer.php';
require_once DIR_SYSTEM . 'library/opex/trait_opex_utils.php';

/**
 * @Component
 */
class ControllerExtensionModuleLbtCode extends Controller {

    use trait_lbt_customer;
    use trait_opex_utils;

    public function send_code() {

        $this->load->language('extension/module/lbt');

        $telephone = $this->request->post['lbt_phone'] ?? '';
        if (!$telephone) {
            return $this->output_json("error", $this->language->get("lbt_otp_error_please_enter_telephone"));
        }

        $redirect = $this->request->post['lbt_redirect'] ?? '';
        if (!$redirect) {
            return $this->output_json("error", $this->language->get("lbt_otp_error_missing_redirect_param"));
        }

        // Find customer with telephone.
        $customer_info = $this->validate_by_telephone($telephone);
        if (!$customer_info || $this->error) {
            return $this->output_json("error", $this->error);
        }

        //Generate, Save and Send the code by SMS (event system)
        $code        = $this->generate_random_string(6, false);
        $customer_id = $customer_info['customer_id'];
        $iso_code_2  = $this->get_iso_code_by_customer_id($customer_info['customer_id']);

        $this->load->model('extension/module/lbt_dao');
        $this->model_extension_module_lbt_dao->save_passwordless_code($telephone, $code, $customer_id, $redirect, $iso_code_2);  //sms by event system, be careful to args: cbe5f
        if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] passwordless code saved. SMS should be sent (event system)");

        $this->output_json("success", $this->language->get("lbt_otp_text_code_was_sent"));
    }

    public function verify_code() {

        $this->load->language('extension/module/lbt');

        $code = $this->request->post['lbt_code'] ?? '';
        if (!$code) {
            return $this->output_json("error", $this->language->get("lbt_otp_error_code_cannot_be_empty"));
        }


        $lbt_record = $this->get_my_record_and_login_or_not($code);
        if (! $lbt_record) {
            $this->error = $this->language->get("lbt_otp_error_invalid_code");
        }

        if ($this->error) {
            return $this->output_json("error", $this->error);
        } else {
            unset($this->session->data['redirect']);
            return $this->output_json("success", $lbt_record["redirect"]);
        }
    }

    /**
     * @Endpoint
     */
    public function verify_code_magic() {
        $code = $this->request->get['code'] ?? '';
        if (!$code) {
            $this->session->data['error'] = $this->language->get("lbt_otp_error_invalid_link");
            $this->response->redirect($this->url->link('account/login', '', true));
        }

        $lbt_record = $this->get_my_record_and_login_or_not($code);
        if (! $lbt_record) {
            $this->error = $this->language->get("lbt_otp_error_invalid_or_expired_link");
        }

        //delete old record 3 days.
        $sql = "DELETE FROM `" . DB_PREFIX . "tv_lbt_code` WHERE delete_date < NOW() - INTERVAL 3 DAY";
        $this->db->query($sql);

        if ($this->error) {
            $this->response->redirect($this->url->link('account/login', '', true));
        }else{
            unset($this->session->data['redirect']);
            $this->response->redirect($lbt_record["redirect"]);
        }
    }


    private function get_my_record_and_login_or_not($code) {
        $sql = "SELECT * FROM `" . DB_PREFIX . "tv_lbt_code` WHERE `code` = '" . $this->db->escape($code) . "' AND delete_date IS NULL";
        $query = $this->db->query($sql);
        if ($query->row) {
            $customer_id = $query->row['customer_id'];
            $this->load->model('account/customer');
            $customer = $this->model_account_customer->getCustomer($customer_id);

            //login the customer
            $this->login_customer($customer['email']);

            //NIKKITA HAS BUG ON HIS SITE, THIS IS WHY THIS IS DISABLED NOW
            //update the record delete_date
            //$sql = "UPDATE `" . DB_PREFIX . "tv_lbt_code` SET delete_date = NOW() WHERE id = " . $query->row['id'];
            //$this->db->query($sql);

            return $query->row;
        }else{
            if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] no record found for code: " . $code);
        }

        //DELETE OLD RECORDS
        $sql = "DELETE FROM `" . DB_PREFIX . "tv_lbt_code` WHERE create_date < DATE_SUB(NOW(), INTERVAL 8 DAY_HOUR)";
        $this->db->query($sql);

        return null;
    }


    private function login_customer($email) {

        $this->load->language('extension/module/lbt');
        $this->load->model('extension/module/lbt_dao');
        $this->load->model('account/customer');


        //password ***** ignored → thanks to override true. Password is salted we can not get it. We must use override: true.
        if (!$this->model_extension_module_lbt_dao->call_oc_login($email, "*****", true)) {

            if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] login failure");

            $this->error = $this->language->get('error_login_by_telephone');

            $this->model_account_customer->addLoginAttempt($email);

        } else {
            if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] login success");
            $this->model_account_customer->deleteLoginAttempts($email);
        }
    }

    private function output_json($status, $message) {
        $json = array(
            "status"  => $status,
            "message" => $message,
        );

        $this->response->addHeader("Content-Type: application/json");
        $this->response->setOutput(json_encode($json));
    }
}