<?php

/**@Component */
class ControllerExtensionModuleLbtCodeFragment extends Controller {

    public function render(): string {

        if (!$this->config->get("lbt_cfg_passwordless_login_by_sms_status")) {
            if ($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] Login By OTP disabled. Aborting!");
            return "";
        }

        $this->load->language('extension/module/lbt');

        if (isset($this->session->data['redirect'])) {
            $data['lbt_redirect'] = $this->session->data['redirect'];
        } else {
            $data['lbt_redirect'] = $this->url->link("checkout/checkout", "", true);
        }
        $data['lbt_send_code_url']   = $this->url->link("extension/module/lbt_code/send_code", "", true);
        $data['lbt_verify_code_url'] = $this->url->link("extension/module/lbt_code/verify_code", "", true);

        //ladda
        $this->document->addScript('catalog/view/javascript/lbt/lib/ladda/spin.min.js');
        $this->document->addScript('catalog/view/javascript/lbt/lib/ladda/ladda.min.js');
        $this->document->addStyle('catalog/view/javascript/lbt/lib/ladda/ladda-themeless.min.css');

        return $this->load->view("extension/module/lbt/fragments/lbt_fmt_at_login", $data);
    }

}