<?php
class ControllerExtensionModuleTelephoneWithCountryCodeSainent extends Controller {
	
	public function info() {
		$json = array();
		
		$json['telephonewithcountrycode_sainent_status'] = $this->config->get('module_telephonewithcountrycode_sainent_status');
		$json['custom_field'] = '';
		$json['allowed_countries'] = array();
		$json['preferredCountries'] = array();
		
		if ($this->config->get('module_telephonewithcountrycode_sainent_status')){
			if(count((array)$this->config->get('module_telephonewithcountrycode_sainent_custom_field')) > 0){
				$json['custom_field'] = implode(",", $this->config->get('module_telephonewithcountrycode_sainent_custom_field'));
			}
			
			$allowed_countries = $this->config->get('module_telephonewithcountrycode_sainent_allowed_countries');
			
			$preferred_countries = $this->config->get('module_telephonewithcountrycode_sainent_preferred_countries');
			
			if(count((array)$allowed_countries) > 0){
				foreach($allowed_countries as $country){
					$country = trim($country);
					$json['allowed_countries'][] = $country;
				}
			}
			if(count((array)$preferred_countries) > 0){
				foreach($preferred_countries as $country){
					$country = trim($country);
					if(in_array($country,$preferred_countries)){
						$json['preferredCountries'][] =  $country;
					}
				}
			}
		}
		
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}