<?php
class ControllerExtensionModuleWebskyOtp extends Controller
{
	private $error = array();

	public function index()
	{
		if ($this->customer->isLogged()) {
			$this->response->redirect($this->url->link('account/account', '', true));
		}

		$this->load->model('account/customer');
		$this->load->language('extension/module/websky_otp');
		$data['international'] = $this->config->get('module_websky_otp_international');
		$data['login'] = $this->config->get('module_websky_otp_login');
		$data['password'] = $this->config->get('module_websky_otp_password');
		$data['country'] = $this->config->get('module_websky_otp_country');
		///internation ////
		$data['default_country'] = $this->config->get('module_websky_otp_default_country');
		$country_header = $this->config->get('module_websky_otp_country_header');
		$countries = $this->config->get('module_websky_otp_country');
		$data['country_header'] = json_encode($country_header);
		$data['countries'] = json_encode($countries);
		$data['welcome_text'] = $this->config->get('module_websky_otp_welcome_text')[$this->config->get('config_language_id')];
		$data['welcome_text_header'] = $this->config->get('module_websky_otp_welcome_text_header')[$this->config->get('config_language_id')];
		//new language add
		if ($this->config->get('module_websky_otp_text_login_or_register')[$this->config->get('config_language_id')]) {
			$data['text_login_or_register'] = $this->config->get('module_websky_otp_text_login_or_register')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_telephone')[$this->config->get('config_language_id')]) {
			$data['text_telephone'] = $this->config->get('module_websky_otp_text_telephone')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_continue_otp')[$this->config->get('config_language_id')]) {
			$data['text_continue_otp'] = $this->config->get('module_websky_otp_text_continue_otp')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_telephone_email')[$this->config->get('config_language_id')]) {
			$data['text_telephone_email'] = $this->config->get('module_websky_otp_text_telephone_email')[$this->config->get('config_language_id')];
		}



		if ($this->config->get('module_websky_otp_error_phone_email_valid')[$this->config->get('config_language_id')]) {
			$data['error_phone_email_valid'] = $this->config->get('module_websky_otp_error_phone_email_valid')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_error_phone_valid')[$this->config->get('config_language_id')]) {
			$data['error_phone_valid'] = $this->config->get('module_websky_otp_error_phone_valid')[$this->config->get('config_language_id')];
		}


		$data['photo'] = $this->config->get('module_websky_otp_image');
		$data['imageurl'] = HTTPS_SERVER . 'image/';
		$data['delay'] = $this->config->get('module_websky_otp_delay');
		$this->document->setTitle($this->language->get('heading_title'));
		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_account'),
			'href' => $this->url->link('account/account', '', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_login'),
			'href' => $this->url->link('account/login', '', true)
		);

		if (isset($this->session->data['error'])) {
			$data['error_warning'] = $this->session->data['error'];

			unset($this->session->data['error']);
		} elseif (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['action'] = $this->url->link('extension/module/websky_otp/verify', '', true);

		$data['register'] = $this->url->link('account/register', '', true);
		$data['forgotten'] = $this->url->link('account/forgotten', '', true);

		// Added strpos check to pass McAfee PCI compliance test (http://forum.opencart.com/viewtopic.php?f=10&t=12043&p=151494#p151295)
		if (isset($this->request->post['redirect']) && (strpos($this->request->post['redirect'], $this->config->get('config_url')) !== false || strpos($this->request->post['redirect'], $this->config->get('config_ssl')) !== false)) {
			$data['redirect'] = $this->request->post['redirect'];
		} elseif (isset($this->session->data['redirect'])) {
			$data['redirect'] = $this->session->data['redirect'];

			unset($this->session->data['redirect']);
		} else {
			$data['redirect'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['email'])) {
			$data['email'] = $this->request->post['email'];
		} else {
			$data['email'] = '';
		}
		//	if ($this->journal3->document->isPopup()) {
		//		echo 555;
		//		}else{
		//	    echo 66;
		//		}
		if (isset($this->request->get['change_number'])) {
			$data['change_nember'] = 2;
		} else {
			$data['change_nember'] = 1;
		}

		if (isset($this->request->get['otp_login'])) {
			$data['login'] = $this->request->get['otp_login'];
		} 

		if(isset($this->request->get['emailsend']) && $this->request->get['emailsend']==1){
			$data['login']=0;
	         }elseif(isset($this->request->get['emailsend']) && $this->request->get['emailsend']==0){ 
			$data['login']=1;
	       }
		if (isset($this->request->get['design'])) {
			$data['design'] = $this->request->get['design'];
		} else {
			$data['design'] = $this->config->get('module_websky_otp_designs');
		}

		//$this->document->addStyle('catalog/view/theme/default/stylesheet/intlTelInput.css');
		//$this->document->addScript('catalog/view/javascript/js/intlTelInput.js');
		$this->document->addStyle('catalog/view/theme/default/stylesheet/otp.css');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');
		$data['header_otp'] = $this->load->controller('extension/module/websky_otp/header');
		
		$this->response->setOutput($this->load->view('extension/module/websky_otp/design', $data));
		//$this->response->setOutput($this->load->view('extension/module/websky_otp/design_select', $data));
	}

	public function header()
	{


		// Analytics
		$this->load->model('setting/extension');

		$data['analytics'] = array();

		$analytics = $this->model_setting_extension->getExtensions('analytics');

		foreach ($analytics as $analytic) {
			if ($this->config->get('analytics_' . $analytic['code'] . '_status')) {
				$data['analytics'][] = $this->load->controller('extension/analytics/' . $analytic['code'], $this->config->get('analytics_' . $analytic['code'] . '_status'));
			}
		}

		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}

		if (is_file(DIR_IMAGE . $this->config->get('config_icon'))) {
			$this->document->addLink($server . 'image/' . $this->config->get('config_icon'), 'icon');
		}

		$data['title'] = $this->document->getTitle();

		$data['base'] = $server;
		$data['description'] = $this->document->getDescription();
		$data['keywords'] = $this->document->getKeywords();
		$data['links'] = $this->document->getLinks();
		$data['styles'] = $this->document->getStyles();
		$data['scripts'] = $this->document->getScripts('header');
		$data['lang'] = $this->language->get('code');
		$data['direction'] = $this->language->get('direction');

		$data['name'] = $this->config->get('config_name');
       return $this->load->view('extension/module/websky_otp/header', $data);
	}

	public function verify_design()
	{
		if($this->request->get['emailsend']==1){
			$data['emailsend']=1;
	         }else {
			$data['emailsend']=0;
	       }

		$this->load->language('extension/module/websky_otp');
		$this->document->setTitle($this->language->get('heading_title'));
		$data['delay'] = $this->config->get('module_websky_otp_delay');
		$data['password_status'] = $this->config->get('module_websky_otp_password');
		$this->load->model('extension/module/websky_otp');
		
		$password_user = $this->model_extension_module_websky_otp->getCustomerByPassword($this->request->get['telephone']);
		if (isset($password_user)) {
			$data['password_user'] = $password_user;
		} else {
			$data['password_user'] = '';
		}
		$this->load->model('extension/module/websky_otp');
		$data['telephone'] = $this->request->get['telephone'];
		$customer_info = $this->model_extension_module_websky_otp->getCustomer($this->request->get['telephone']);
		if ($customer_info) {
			$data['account'] = 'login';
			$data['text_old'] = sprintf($this->language->get('verify_text_login'), $data['telephone']);

			if ($this->config->get('module_websky_otp_verify_text_login')[$this->config->get('config_language_id')]) {
				$data['text_old'] = sprintf($this->config->get('module_websky_otp_verify_text_login')[$this->config->get('config_language_id')], $data['telephone']);
			}
			if($this->request->get['emailsend']==1){
				$data['text_old'] = sprintf($this->language->get('verify_text_login_email'), $data['telephone']);
				if ($this->config->get('module_websky_otp_verify_text_login_email')[$this->config->get('config_language_id')]) {
					$data['text_old'] = sprintf($this->config->get('module_websky_otp_verify_text_login_email')[$this->config->get('config_language_id')], $data['telephone']);
				}
			}
			if ($this->config->get('module_websky_otp_test') == 1) {
				$data['text_old'] = sprintf($this->language->get('verify_text_login_test'), $data['telephone']);

				if ($this->config->get('module_websky_otp_verify_text_login_test')[$this->config->get('config_language_id')]) {
					$data['text_old'] = sprintf($this->config->get('module_websky_otp_verify_text_login_test')[$this->config->get('config_language_id')], $data['telephone']);
				}
               
				if($this->request->get['emailsend']==1){
					if ($this->config->get('module_websky_otp_verify_text_login_test_email')[$this->config->get('config_language_id')]) {
						$data['text_old'] = sprintf($this->config->get('module_websky_otp_verify_text_login_test_email')[$this->config->get('config_language_id')], $data['telephone']);
					}
		    	}
			}
		} else {
			$data['account'] = 'register';
			$data['text_old'] = sprintf($this->language->get('verify_text_new'), $data['telephone']);
			if ($this->config->get('module_websky_otp_verify_text_new')[$this->config->get('config_language_id')]) {
				$data['text_old'] = sprintf($this->config->get('module_websky_otp_verify_text_new')[$this->config->get('config_language_id')], $data['telephone']);
			}
			if($this->request->get['emailsend']==1){
				$data['text_old'] = sprintf($this->language->get('verify_text_new_email'), $data['telephone']);
				if ($this->config->get('module_websky_otp_verify_text_new_email')[$this->config->get('config_language_id')]) {
					$data['text_old'] = sprintf($this->config->get('module_websky_otp_verify_text_new_email')[$this->config->get('config_language_id')], $data['telephone']);
				}
			}
			if ($this->config->get('module_websky_otp_test') == 1) {
				$data['text_old'] = sprintf($this->language->get('verify_text_new_test'), $data['telephone']);
                if ($this->config->get('module_websky_otp_verify_text_new_test')[$this->config->get('config_language_id')]) {
					$data['text_old'] = sprintf($this->config->get('module_websky_otp_verify_text_new_test')[$this->config->get('config_language_id')], $data['telephone']);
				}

				if($this->request->get['emailsend']==1){
					$data['text_old'] = sprintf($this->language->get('verify_text_new_test_email'), $data['telephone']);
					if ($this->config->get('module_websky_otp_verify_text_new_test_email')[$this->config->get('config_language_id')]) {
						$data['text_old'] = sprintf($this->config->get('module_websky_otp_verify_text_new_test_email')[$this->config->get('config_language_id')], $data['telephone']);
					}
				}
			}

		}

		if ($this->config->get('module_websky_otp_text_header')[$this->config->get('config_language_id')]) {
			$data['text_header'] = $this->config->get('module_websky_otp_text_header')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_chenge')[$this->config->get('config_language_id')]) {
			$data['text_chenge'] = $this->config->get('module_websky_otp_text_chenge')[$this->config->get('config_language_id')];
		}
		if($this->request->get['emailsend']==1){
			if ($this->config->get('module_websky_otp_text_chenge_email')[$this->config->get('config_language_id')]) {
				$data['text_chenge'] = $this->config->get('module_websky_otp_text_chenge_email')[$this->config->get('config_language_id')];
			}
		}

		if ($this->config->get('module_websky_otp_text_delay')[$this->config->get('config_language_id')]) {
			$data['text_delay'] = $this->config->get('module_websky_otp_text_delay')[$this->config->get('config_language_id')];
		}
		if ($this->config->get('module_websky_otp_text_sendcode')[$this->config->get('config_language_id')]) {
			$data['text_sendcode'] = $this->config->get('module_websky_otp_text_sendcode')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_login_password')[$this->config->get('config_language_id')]) {
			$data['text_login_password'] = $this->config->get('module_websky_otp_text_login_password')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_Confirm_code')[$this->config->get('config_language_id')]) {
			$data['text_Confirm_code'] = $this->config->get('module_websky_otp_text_Confirm_code')[$this->config->get('config_language_id')];
		}
           $data['login_verify'] = $this->url->link('extension/module/websky_otp&popup=login', '', true);
		   $data['image_verify'] = $this->config->get('module_websky_otp_image_verify');
		   $data['imageurl'] = HTTPS_SERVER . 'image/';
		$this->response->setOutput($this->load->view('extension/module/websky_otp/design_verify', $data));

	}



	public function send_code()
	{
		$this->load->language('extension/module/websky_otp');
        if($this->request->get['emailsend']==1){
                $emailsend=1;
		}else {
			    $emailsend=0;
		}
		$this->load->model('extension/module/websky_otp');
		$json['telephone'] = $this->request->post['telephone'];
		$customer_info = $this->model_extension_module_websky_otp->getCustomer($this->request->post['telephone']);
         if ($customer_info) {
			$json['account'] = 'old';
			$this->model_extension_module_websky_otp->UpdateCode($this->request->post['telephone'], $customer_info['customer_id'],$emailsend);
		} else {

			$this->model_extension_module_websky_otp->UpdateRegisterCode($this->request->post['telephone'],$emailsend);
			$json['account'] = 'new';
		}
		if (isset($this->session->data['block_user'])) {
			$time = $this->config->get("module_websky_otp_block_time") - (time() - $this->session->data['last_submit']);
			$json['error'] = sprintf($this->language->get('text_unlock'), $time);

			if ($this->config->get('module_websky_otp_text_unlock')[$this->config->get('config_language_id')]) {
				$json['error'] = sprintf($this->config->get('module_websky_otp_text_unlock')[$this->config->get('config_language_id')], $time);
			}
		} else {
			$json['success'] = $this->language->get('success_user');

			if ($this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')]) {
				$json['success'] = $this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')];
			}
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
	public function verify_login()
	{
		$this->load->model('extension/module/websky_otp');
	
		$this->load->language('extension/module/websky_otp');
		$json = array();
		if ($this->customer->login_verify($this->request->post['telephone'], $this->request->post['verify_code'])) {
			$json['success'] = $this->language->get('success_user');
			if ($this->config->get('module_websky_otp_fill_form') == 1 && $this->customer->getLastName() == '') {
			  
				$json['fill_form'] = $this->config->get('module_websky_otp_fill_form');
				$this->session->data['verify'] = $this->request->post['telephone'];
			}
			if (isset($this->session->data['redirect_otp'])) {
				$json['redirect'] = $this->session->data['redirect_otp'];
			} else {
				$json['redirect'] = $this->url->link('checkout/checkout', '', true);
			}
		} else {
			$json['error'] = $this->language->get('error_code');
			if ($this->config->get('module_websky_otp_error_code')[$this->config->get('config_language_id')]) {
				$json['error'] = $this->config->get('module_websky_otp_error_code')[$this->config->get('config_language_id')];
			}

		}


		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}


	public function verify_register()
	{
		$this->load->language('extension/module/websky_otp');

		if ($this->session->data['code'] == $this->request->post['verify_code']) {

			if ($this->config->get('module_websky_otp_fill_form') == 1) {
				$json['fill_form'] = $this->config->get('module_websky_otp_fill_form');
				$this->session->data['verify'] = $this->request->post['telephone'];
			} else {
				unset($this->session->data['code']);
				if($this->request->get['emailsend']==1){
					$this->request->post['email'] = $this->request->post['telephone'];
					$login_field = $this->request->post['telephone'];
					$this->request->post['telephone']='';
			}else {
				$this->request->post['email'] = $this->request->post['telephone'] . '@mail.com';
				$login_field = $this->request->post['telephone'];
			}
				
				$this->load->model('extension/module/websky_otp');
				$customer_id = $this->model_extension_module_websky_otp->addCustomer($this->request->post);
				$this->db->query("UPDATE " . DB_PREFIX . "customer SET sms_verify_code = '" . (int) $this->request->post['verify_code'] . "' WHERE customer_id = '" . (int) $customer_id . "'");
				if ($this->customer->login_verify($login_field , $this->request->post['verify_code'])) {
					$json['success'] = $this->language->get('success_user');

					if ($this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')]) {
						$json['success'] = $this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')];
					}
				} else {
					$json['error'] = $this->language->get('error_user');

					if ($this->config->get('module_websky_otp_error_user')[$this->config->get('config_language_id')]) {
						$json['error'] = $this->config->get('module_websky_otp_error_user')[$this->config->get('config_language_id')];
					}
				}
			}
		} else {
			$json['error'] = $this->language->get('error_code');

			if ($this->config->get('module_websky_otp_error_code')[$this->config->get('config_language_id')]) {
				$json['error'] = $this->config->get('module_websky_otp_error_code')[$this->config->get('config_language_id')];
			}
		}


		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function fill_form_check()
	{
		$this->load->language('extension/module/websky_otp');
		$this->load->model('extension/module/websky_otp');

		$this->load->model('account/customer');

		if ((utf8_strlen(trim($this->request->post['firstname'])) < 1) || (utf8_strlen(trim($this->request->post['firstname'])) > 32)) {
			$json['error']['firstname'] = $this->language->get('error_firstname');
			if ($this->config->get('module_websky_otp_error_firstname')[$this->config->get('config_language_id')]) {
				$json['error']['firstname'] = $this->config->get('module_websky_otp_error_firstname')[$this->config->get('config_language_id')];
			}
		}

		if ((utf8_strlen(trim($this->request->post['lastname'])) < 1) || (utf8_strlen(trim($this->request->post['lastname'])) > 32)) {
			$json['error']['lastname'] = $this->language->get('error_lastname');
			if ($this->config->get('module_websky_otp_error_lastname')[$this->config->get('config_language_id')]) {
				$json['error']['lastname'] = $this->config->get('module_websky_otp_error_lastname')[$this->config->get('config_language_id')];
			}
		}

		if ((utf8_strlen($this->request->post['email']) > 96) || !filter_var($this->request->post['email'], FILTER_VALIDATE_EMAIL)) {
			$json['error']['email'] = $this->language->get('error_email_register');

			if ($this->config->get('module_websky_otp_error_email_register')[$this->config->get('config_language_id')]) {
				$json['error']['email'] = $this->config->get('module_websky_otp_error_email_register')[$this->config->get('config_language_id')];
			}
		}

		if ((utf8_strlen($this->request->post['telephone']) < 8) || (utf8_strlen($this->request->post['telephone']) > 32)) {
			$json['error']['telephone'] = $this->language->get('error_telephone_register');

			if ($this->config->get('module_websky_otp_error_telephone_register')[$this->config->get('config_language_id')]) {
				$json['error']['telephone'] = $this->config->get('module_websky_otp_error_telephone_register')[$this->config->get('config_language_id')];
			}
		}
        if($this->request->get['emailsend'] !=1){
		if ($this->model_account_customer->getTotalCustomersByEmail($this->request->post['email'])) {
			$json['error']['warning'] = $this->language->get('error_exists');
			if ($this->config->get('module_websky_otp_error_exists')[$this->config->get('config_language_id')]) {
				$json['error']['warning'] = $this->config->get('module_websky_otp_error_exists')[$this->config->get('config_language_id')];
			}
		}
        }
		
		if (!isset($json)) {
			if($this->request->get['emailsend']==1){
                $verify=$this->request->post['email'];
		}else {
			    $verify=$this->request->post['telephone'];
		}
			if ($verify == $this->session->data['verify']) {

				//$this->request->post['email'] = $this->request->post['telephone'] . '@mail.com';
				$this->load->model('extension/module/websky_otp');
				$customer_info = $this->model_extension_module_websky_otp->getCustomer($verify);
				if ($customer_info) {
					$this->model_extension_module_websky_otp->fill_form($this->request->post);
					$customer_id = $customer_info['customer_id'];
				} else {
					$customer_id = $this->model_extension_module_websky_otp->register($this->request->post);
				}

				$this->db->query("UPDATE " . DB_PREFIX . "customer SET sms_verify_code = '" . (int) $this->session->data['code'] . "' WHERE customer_id = '" . (int) $customer_id . "'");
				if ($this->customer->login_verify($verify, $this->session->data['code'])) {
					$json['success'] = $this->language->get('success_user');
					if ($this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')]) {
						$json['success'] = $this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')];
					}
					unset($this->session->data['code']);
				} else {
					$json['error']['warning'] = $this->language->get('error_user');
					if ($this->config->get('module_websky_otp_error_user')[$this->config->get('config_language_id')]) {
						$json['error']['warning'] = $this->config->get('module_websky_otp_error_user')[$this->config->get('config_language_id')];
					}
				}

			} else {
				$json['error']['warning'] = $this->language->get('error_code');
				if ($this->config->get('module_websky_otp_error_code')[$this->config->get('config_language_id')]) {
					$json['error']['warning'] = $this->config->get('module_websky_otp_error_code')[$this->config->get('config_language_id')];
				}
			}
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}


	public function fill_form()
	{
		$this->load->language('extension/module/websky_otp');
		$this->document->setTitle($this->language->get('heading_title'));

		$data['telephone'] = $this->request->get['telephone'];


		if ($this->config->get('module_websky_otp_text_login_fill_form')[$this->config->get('config_language_id')]) {
			$data['text_login_fill_form'] = $this->config->get('module_websky_otp_text_login_fill_form')[$this->config->get('config_language_id')];
		}
		if ($this->config->get('module_websky_otp_text_firstname')[$this->config->get('config_language_id')]) {
			$data['text_firstname'] = $this->config->get('module_websky_otp_text_firstname')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_lastname')[$this->config->get('config_language_id')]) {
			$data['text_lastname'] = $this->config->get('module_websky_otp_text_lastname')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_email')[$this->config->get('config_language_id')]) {
			$data['text_email'] = $this->config->get('module_websky_otp_text_email')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_register')[$this->config->get('config_language_id')]) {
			$data['text_register'] = $this->config->get('module_websky_otp_text_register')[$this->config->get('config_language_id')];
		}

		$data['photo'] = $this->config->get('module_websky_otp_image_fill');
		$data['imageurl'] = HTTPS_SERVER . 'image/';
		if($this->request->get['emailsend']==1){
			$data['emailsend']=1;
	         }else {
			$data['emailsend']=0;
	       }
		   $data['international'] = $this->config->get('module_websky_otp_international');
		$data['login'] = $this->config->get('module_websky_otp_login');
		$data['country'] = $this->config->get('module_websky_otp_country');
		///internation ////
		$data['default_country'] = $this->config->get('module_websky_otp_default_country');
		$country_header = $this->config->get('module_websky_otp_country_header');
		$countries = $this->config->get('module_websky_otp_country');
		$data['country_header'] = json_encode($country_header);
		$data['countries'] = json_encode($countries);
		$this->response->setOutput($this->load->view('extension/module/websky_otp/design_form', $data));

	}

	public function forgotten()
	{


		$this->load->language('account/forgotten');

		$this->load->model('account/customer');

		if ($this->model_account_customer->getTotalCustomersByEmail($this->request->post['telephone'])) {
			$this->model_account_customer->editCode($this->request->post['telephone'], token(40));

			$json['success'] = $this->language->get('text_success');



		} else {
			$json['error'] = $this->language->get('error_email');

		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));

	}

	public function login_with_password()
	{
		if($this->request->get['emailsend']==1){
			$data['emailsend']=1;
	         }else {
			$data['emailsend']=0;
	       }
		$this->load->language('extension/module/websky_otp');
		if (isset($this->request->get['telephone'])) {
			$data['telephone'] = $this->request->get['telephone'];
			$data['login_with_telephone'] = true;
		}
		if (isset($this->request->get['email'])) {
			$data['telephone'] = $this->request->get['email'];
		}

		if ($this->config->get('module_websky_otp_text_login_password')[$this->config->get('config_language_id')]) {
			$data['text_login_password'] = $this->config->get('module_websky_otp_text_login_password')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_login')[$this->config->get('config_language_id')]) {
			$data['text_login'] = $this->config->get('module_websky_otp_text_login')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_password')[$this->config->get('config_language_id')]) {
			$data['text_password'] = $this->config->get('module_websky_otp_text_password')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_login_sms')[$this->config->get('config_language_id')]) {
			$data['text_login_sms'] = $this->config->get('module_websky_otp_text_login_sms')[$this->config->get('config_language_id')];
		}

		if ($this->config->get('module_websky_otp_text_forgotten')[$this->config->get('config_language_id')]) {
			$data['text_forgotten'] = $this->config->get('module_websky_otp_text_forgotten')[$this->config->get('config_language_id')];
		}


		$this->response->setOutput($this->load->view('extension/module/websky_otp/design_password', $data));

	}

	public function check_email()
	{

		$this->load->language('extension/module/websky_otp');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('extension/module/websky_otp');
		$json['email'] = $this->request->post['telephone'];
		$json['customer'] = $this->model_extension_module_websky_otp->getCustomerByEmail($this->request->post['telephone']);
		if ($json['customer']) {
			$json['success'] = $this->language->get('success_user');
			if ($this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')]) {
				$json['success'] = $this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')];
			}
		} else {
			$json['error'] = $this->language->get('error_email');
			if ($this->config->get('module_websky_otp_error_email')[$this->config->get('config_language_id')]) {
				$json['error'] = $this->config->get('module_websky_otp_error_email')[$this->config->get('config_language_id')];
			}
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}

	public function success()
	{
		$this->load->model('account/customer');
		$this->load->language('extension/module/websky_otp');

		$this->document->setTitle($this->language->get('heading_title'));
		$data['text_color'] = $this->config->get('module_websky_otp_bg_color');


		$data['welcome_text'] = $this->config->get('module_websky_otp_welcome_text')[$this->config->get('config_language_id')];
		$data['welcome_text_header'] = $this->config->get('module_websky_otp_welcome_text_header')[$this->config->get('config_language_id')];
		$data['photo'] = $this->config->get('module_websky_otp_image');
		$data['imageurl'] = HTTPS_SERVER . 'image/';
		$this->load->model('extension/module/websky_otp');
		$password = $this->model_extension_module_websky_otp->getCustomerByPassword($this->customer->getTelephone());

		if ($password) {
			$data['password_status'] = true;
		} else {
			$data['password_status'] = false;
		}
		if ($this->customer->getLastName() == '') {
			$data['edit_status'] = true;
		} else {
			$data['edit_status'] = false;
		}
		if (isset($this->session->data['redirect_otp'])) {
			$data['redirect'] = $this->session->data['redirect_otp'];

			unset($this->session->data['redirect_otp']);
		} else {
			$data['redirect'] = $this->url->link('common/home', '', true);
		}

		if ($this->config->get('module_websky_otp_text_continue_otp')[$this->config->get('config_language_id')]) {
			$data['text_continue_otp'] = $this->config->get('module_websky_otp_text_continue_otp')[$this->config->get('config_language_id')];
		}
		if ($this->config->get('module_websky_otp_text_complate_user')[$this->config->get('config_language_id')]) {
			$data['text_complate_user'] = $this->config->get('module_websky_otp_text_complate_user')[$this->config->get('config_language_id')];
		}
		if ($this->config->get('module_websky_otp_text_edit')[$this->config->get('config_language_id')]) {
			$data['text_edit'] = $this->config->get('module_websky_otp_text_edit')[$this->config->get('config_language_id')];
		}

		$data['password'] = $this->url->link('account/password', '', true);
		$data['edit'] = $this->url->link('account/edit', '', true);
		$data['home'] = $this->url->link('common/home', '', true);
		$this->response->setOutput($this->load->view('extension/module/websky_otp/design_success', $data));

	}

	public function password_check()
	{
		$this->load->language('extension/module/websky_otp');
		$this->document->setTitle($this->language->get('heading_title'));

		$json['telephone'] = $this->request->post['telephone'];
		$json['password'] = $this->request->post['password'];
		if ($this->request->post['password']) {
		     if ($this->customer->login($this->request->post['telephone'], $this->request->post['password'])) {
				$json['success'] = $this->language->get('success_user');
				if ($this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')]) {
					$json['success'] = $this->config->get('module_websky_otp_success_user')[$this->config->get('config_language_id')];
				}
			} else {
				$json['error'] = $this->language->get('error_password');
				if ($this->config->get('module_websky_otp_error_password')[$this->config->get('config_language_id')]) {
					$json['error'] = $this->config->get('module_websky_otp_error_password')[$this->config->get('config_language_id')];
				}

			}
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));

	}

	public function editCustomer(&$route, &$args, &$output)
	{
		if ($this->customer->getLastName() == '') {
			$this->db->query("UPDATE " . DB_PREFIX . "customer SET firstname = '" . $this->db->escape($args[1]['firstname']) . "', lastname = '" . $this->db->escape($args[1]['lastname']) . "' WHERE customer_id = '" . (int) $this->customer->getId() . "'");
		}
	}
	public function editOrderinfo(&$route, &$args)
	{
		if (isset($args[0])) {
			$order_id = $args[0];
		} else {
			$order_id = 0;
		}
		if (isset($args[1])) {
			$order_status_id = $args[1];
		} else {
			$order_status_id = 0;
		}

		// We need to grab the old order status ID
		$order_info = $this->model_checkout_order->getOrder($order_id);
		if (!$order_info['order_status_id'] && $order_status_id) {
			if (!$order_info['firstname']) {
				$this->db->query("UPDATE " . DB_PREFIX . "order SET firstname = '" . $this->db->escape($this->customer->getFirstName()) . "', lastname = '" . $this->db->escape($this->customer->getLastName()) . "' WHERE order_id = '" . (int) $order_id . "'");

			}
		} elseif (!$order_info['firstname']) {
			$this->db->query("UPDATE " . DB_PREFIX . "order SET firstname = '" . $this->db->escape($order_info['payment_firstname']) . "', lastname = '" . $this->db->escape($order_info['payment_lastname']) . "' WHERE order_id = '" . (int) $order_id . "'");

		}

	}
}