<?php

require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLoader.php';
require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLibrary.php';

class ControllerExtensionPaymentMyfatoorah extends Controller {

    private $mfCode = 'myfatoorah_pg';
    private $orderId;
    private $mfObj;
    private $order;
    private $oc;

    //---------------------------------------------------------------------------------------------------------------------------------------------------
    public function __construct($registry) {
        parent::__construct($registry);
        $this->oc = $this->getOpenCartVersionInfo();
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function registerData() {

        //get order info
        $this->load->model('checkout/order');
        $this->order = $this->model_checkout_order->getOrder($this->orderId);
        if (!$this->order) {
            return $this->displayError('Ops, you are accessing wrong data');
        }

        //get MyFatoorah object
        $logger = new Log($this->mfCode . '.log');
        $isLog  = !empty($this->config->get($this->oc['code'] . '_debug'));

        $mfConfig = [
            'apiKey'     => $this->config->get($this->oc['code'] . '_apiKey'),
            'isTest'     => !empty($this->config->get($this->oc['code'] . '_test')),
            'vcCode'     => $this->config->get($this->oc['code'] . '_countryMode'),
            'loggerObj'  => ($isLog) ? $logger : null,
            'loggerFunc' => 'write'
        ];

        $this->mfObj = new MyFatoorahPaymentStatus($mfConfig);
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------

    public function webhook() {

        //important line
        $secretKey = $this->config->get($this->oc['code'] . '_webhook_secret_key');
        if (empty(trim($secretKey))) {
            die;
        }

        $apache      = apache_request_headers();
        $headers     = array_change_key_case($apache);
        $mfSignature = empty($headers['myfatoorah-signature']) ? die : $headers['myfatoorah-signature'];

        $body    = file_get_contents("php://input");
        $webhook = json_decode($body, true);

        $data      = (empty($webhook['Data'])) ? die : $webhook['Data'];
        $eventType = (isset($webhook['EventType']) && $webhook['EventType'] == 1) ? $webhook['EventType'] : die;

        MyFatoorahPaymentStatus::isSignatureValid($data, $secretKey, $mfSignature, $eventType) ? $this->TransactionsStatusChanged($data) : die;
    }

//-----------------------------------------------------------------------------------------------------------------------------

    private function TransactionsStatusChanged($data) {

        //to allow the callback code run 1st
        sleep(5);

        //get order info
        $this->orderId = $data['CustomerReference'];
        $this->registerData();

        //update order info
        $error = $this->setOrderHistory($data['InvoiceId'], 'InvoiceId', '-Webhook');
        if ($error) {
            $this->mfObj->log('In Webhook Exception Block: ' . $error);
        }
        exit($error);
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function callback() {
        $paymentId     = $this->request->get['paymentId'];
        $this->orderId = $this->request->get['orid'];

        if (empty($paymentId) || empty($this->orderId)) {
            return $this->displayError('Ops, you are accessing wrong data');
        }

        $args = [
            'language'  => $this->config->get('config_language'),
            'paymentId' => $paymentId,
            'orid'      => $this->request->get['orid'],
        ];

        $data['paymentId']   = $paymentId;
        $data['completeURL'] = $this->url->link($this->oc['complete'], $args, true);
        $this->response->setOutput($this->load->view($this->oc['view'], $data));
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function complete() {
        $paymentId     = $this->request->get['paymentId'];
        $this->orderId = base64_decode($this->request->get['orid']);

        if (empty($paymentId) || empty($this->orderId)) {
            return $this->displayError('Ops, you are accessing wrong data');
        }

        //get order info
        $this->registerData();

        //update order info
        $error = $this->setOrderHistory($paymentId, 'PaymentId');
        if ($error) {
            return $this->displayError("Order #$this->orderId: $error");
        }

        $args = [
            'language' => $this->config->get('config_language'),
        ];
        $this->response->redirect($this->url->link('checkout/success', $args, true));
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function displayError($errMessage) {

        $args['language'] = $this->config->get('config_language');
        if (!$this->cart->hasProducts()) {
            return $this->response->redirect($this->url->link('checkout/failure', $args, true));
        }

        $url = 'checkout/checkout';
        if (version_compare(VERSION, '4.0', '>=') || $this->config->get('quickcheckout_status') == 1) {
            $url = 'checkout/cart';
        }

        $this->session->data['error'] = $errMessage;
        $this->response->redirect($this->url->link($url, $args, true));
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function setOrderHistory($keyId, $keyType, $source = '') {

        //if the order is not marked as Initial Status or FailedStatus
        if ($this->isOrderSuccess()) {
            return '';
        }

        try {
            $data = $this->mfObj->getPaymentStatus($keyId, $keyType, $this->orderId);
        } catch (Exception $ex) {
            return $ex->getMessage();
        }

        try {
            $customFields = $this->order['payment_custom_field'];

            if ($data->InvoiceStatus == 'Paid') {
                $this->updateOrderInfo($data, $customFields, $source);
                return '';
            } else if ($data->InvoiceStatus == 'Failed' && (empty($customFields['paymentId']) || ($customFields['paymentId'] != $data->focusTransaction->PaymentId))) {
                $this->updateOrderInfo($data, $customFields, $source);
            } else if ($data->InvoiceStatus == 'Expired') {
                //add the history
                $expiredStatus = 14;
                $this->model_checkout_order->{$this->oc['addHistoryFun']}($this->orderId, $expiredStatus, $data->InvoiceError);
            }
        } catch (Exception $ex) {
            $logger = new Log('order_update_exception.log');
            $logger->write($ex->getMessage());
            $logger->write($ex->getTraceAsString());
        }
        return $data->InvoiceError;
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function isOrderSuccess() {
        return $this->order['order_status_id'] != $this->config->get($this->oc['code'] . '_initial_order_status_id') &&
                $this->order['order_status_id'] != $this->config->get($this->oc['code'] . '_failed_order_status_id');
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function updateOrderInfo($data, $customFields, $source) {

        $customFields['paymentId'] = $data->focusTransaction->PaymentId;

        //update the gateway name and payment_custom_field
        $name  = $this->db->escape('MyFatoorah (' . $data->focusTransaction->PaymentGateway . ')');
        $pmStr = version_compare(VERSION, '4.0.2', '>=') ? 'JSON_SET(`payment_method`, "$.name", "' . $name . '")' : "'$name'";
        $this->db->query('UPDATE `' . DB_PREFIX . 'order` SET `payment_method`=' . $pmStr . ', `payment_custom_field`="' . $this->db->escape(json_encode($customFields)) . '" WHERE `order_id`="' . (int) $this->orderId . '";');

        //add the history
        $newStatus = ($data->InvoiceStatus == 'Paid') ? '' : '_failed';
        $msg       = $this->getOrderHistoryNote($data->focusTransaction, $source);
        $this->model_checkout_order->{$this->oc['addHistoryFun']}($this->orderId, $this->config->get($this->oc['code'] . $newStatus . '_order_status_id'), $msg, true, true);
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function getOrderHistoryNote($data, $source = '') {
        $note = "<b>MyFatoorah$source Payment  Details:</b><br>";
        $note .= ' Gateway: ' . $data->PaymentGateway . '<br>';
        $note .= ' Transaction Status: ' . $data->TransactionStatus . '<br>';
        $note .= ' PaymentId: ' . $data->PaymentId . '<br>';
        $note .= ' AuthorizationId: ' . $data->AuthorizationId . '<br>';
        $note .= ' PaidCurrencyValue: ' . $data->PaidCurrencyValue . '<br>';
        $note .= ' PaidCurrency: ' . $data->PaidCurrency . '<br>';
        $note .= empty($data->Error) ? '' : ' Error: ' . $data->Error . '<br>';
        return $note;
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function getOpenCartVersionInfo() {

        //-----------------------------------------
        if (version_compare(VERSION, '4.0', '>=')) {
            $connector = version_compare(VERSION, '4.0.2', '>=') ? '.' : '|';
            return[
                'complete'      => 'extension/myfatoorah/payment/myfatoorah' . $connector . 'complete',
                'view'          => 'extension/myfatoorah/payment/myfatoorah_loader',
                'code'          => 'payment_' . $this->mfCode,
                'addHistoryFun' => 'addHistory',
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '3.0', '>=')) {
            return[
                'complete'      => "extension/payment/myfatoorah/complete",
                'view'          => 'extension/payment/myfatoorah_loader',
                'code'          => 'payment_' . $this->mfCode,
                'addHistoryFun' => 'addOrderHistory',
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '2.3', '>=')) {
            return[
                'complete'      => "extension/payment/myfatoorah/complete",
                'view'          => 'extension/payment/myfatoorah_loader',
                'code'          => $this->mfCode,
                'addHistoryFun' => 'addOrderHistory',
            ];
        }

        //-----------------------------------------
        return[
            'complete'      => "payment/myfatoorah/complete",
            'view'          => 'payment/myfatoorah_loader',
            'code'          => $this->mfCode,
            'addHistoryFun' => 'addOrderHistory',
        ];
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
}
