<?php

define('MYFATOORAH_OC_PLUGIN_VERSION', '2.2.0');

require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLoader.php';
require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLibrary.php';

class MyfatoorahController extends Controller {

    protected $oc;
    protected $mfObj;
    protected $orderInfo;

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function __construct($registry) {
        parent::__construct($registry);

        $this->oc = $this->getOpenCartVersionInfo();
        $this->load->model('checkout/order');

        //get MyFatoorah object
        $logger = new Log($this->mfCode . '.log');
        $isLog  = !empty($this->config->get($this->oc['code'] . '_debug'));

        $mfConfig = [
            'apiKey'     => $this->config->get($this->oc['code'] . '_apiKey'),
            'isTest'     => !empty($this->config->get($this->oc['code'] . '_test')),
            'vcCode'     => $this->config->get($this->oc['code'] . '_countryMode'),
            'loggerObj'  => ($isLog) ? $logger : null,
            'loggerFunc' => 'write'
        ];

        $this->mfObj = new MyFatoorahPaymentEmbedded($mfConfig);
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    protected function getPayload($orderId) {

        $extension = 'extension/';

        if ($this->currency->getValue($this->config->get('config_currency')) != 1) {
            $this->load->language($extension . 'shipping/myfatoorah');
            throw new Exception($this->language->get('error_defult_currency_rate'));
        }
        $this->orderInfo = $this->model_checkout_order->getOrder($orderId);

        $fname = $this->orderInfo['payment_firstname'] ?: $this->orderInfo['firstname'] ?: $this->orderInfo['shipping_firstname'] ?: '';
        $lname = $this->orderInfo['payment_lastname'] ?: $this->orderInfo['lastname'] ?: $this->orderInfo['shipping_lastname'] ?: '';

        $email = $this->orderInfo['email'] ?: null;
        $phone = $this->orderInfo['telephone'] ?? '';

        $phoneArr = $this->mfObj->getPhone($phone);

        $userDefinedField = (!empty($this->config->get($this->oc['code'] . '_saveCard')) && $this->customer->getId()) ? 'CK-' . $this->customer->getId() : '';

        $args = [
            'language' => $this->config->get('config_language'),
            'orid'     => base64_encode($orderId),
        ];
        $url  = $this->url->link($this->oc['callback'], $args, true);

        $shippingAddress = !empty($this->orderInfo['shipping_address_1']) ? $this->orderInfo['shipping_address_1'] . ' ' . $this->orderInfo['shipping_address_2'] : '';
        $customerAddress = [
            'Block'               => '',
            'Street'              => '',
            'HouseBuildingNo'     => '',
            'Address'             => $this->orderInfo['shipping_city'] . ', ' . $this->orderInfo['shipping_zone'] . ', ' . $this->orderInfo['shipping_postcode'] . ', ' . $this->orderInfo['shipping_country'],
            'AddressInstructions' => $shippingAddress,
        ];

        $shippingCode   = $this->orderInfo['shipping_code'] ?? $this->orderInfo['shipping_method']['code'] ?? $this->orderInfo['shipping_method'];
        $shippingMethod = ($shippingCode == 'myfatoorah.dhl') ? 1 : (($shippingCode == 'myfatoorah.aramex') ? 2 : null);

        $shippingConsignee = null;
        if ($shippingMethod) {
            $shippingConsignee = [
                'PersonName'   => $fname . ' ' . $lname,
                'Mobile'       => $phoneArr[1],
                'EmailAddress' => $email,
                'LineAddress'  => $shippingAddress,
                'CityName'     => $this->orderInfo['shipping_city'] ?: $this->orderInfo['shipping_zone'],
                'PostalCode'   => $this->orderInfo['shipping_postcode'],
                'CountryCode'  => $this->orderInfo['shipping_iso_code_2'],
            ];
        }

        $cartData     = $this->getCartData($shippingMethod);
        $amount       = $cartData['amount'];
        $invoiceItems = $cartData['invoiceItems'];
        $newDesign    = ($this->config->get($this->oc['code'] . '_payment_type') == 'multigateways') ? ' - New Design' : null;

        return [
            'CustomerName'       => $fname . ' ' . $lname,
            'InvoiceValue'       => "$amount",
            'DisplayCurrencyIso' => $this->session->data['currency'], //don't use $this->orderInfo['currency_code'], becuase of oc 4.0.1
            'CustomerEmail'      => $email,
            'CallBackUrl'        => $url,
            'ErrorUrl'           => $url,
            'MobileCountryCode'  => $phoneArr[0],
            'CustomerMobile'     => $phoneArr[1],
            'Language'           => $this->language->get('code'),
            'CustomerReference'  => $orderId,
            'CustomerCivilId'    => '',
            'UserDefinedField'   => $userDefinedField,
            'ExpiryDate'         => '',
            'SourceInfo'         => 'OpenCart ' . VERSION . ' - ' . $this->mfCode . ' ' . MYFATOORAH_OC_PLUGIN_VERSION . $newDesign,
            'CustomerAddress'    => $customerAddress,
            'ShippingConsignee'  => $shippingConsignee,
            'ShippingMethod'     => $shippingMethod,
            'InvoiceItems'       => $invoiceItems,
            'Suppliers'          => $this->getSupplierInfo("$amount"),
        ];
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function getCartData($shippingMethod = null) {

        $amount          = 0;
        $mfShipping      = 0;
        $invoiceItemsArr = [];

        //don't use $this->orderInfo['currency_code'], becuase of oc 4.0.1
        $currency = $this->session->data['currency'];

        //fill vars
        $getProducts = $getVouchers = $getTotals   = '';
        extract($this->oc['accountOrderFunc']);

        //---------------------product items
        $orderId         = $this->session->data['order_id'];
        $this->orderInfo = empty($this->orderInfo) ? $this->model_checkout_order->getOrder($orderId) : $this->orderInfo;

        $this->load->model('account/order');

        $orderProducts = $this->model_account_order->{$getProducts}($orderId);
        $this->load->model('catalog/product');

        foreach ($orderProducts as $product) {
            $productInfo = $this->model_catalog_product->getProduct($product['product_id']);

            $weightRate    = ($shippingMethod) ? $this->mfObj->getWeightRate($this->weight->getUnit($productInfo['weight_class_id'])) : 1;
            $dimensionRate = ($shippingMethod) ? $this->mfObj->getDimensionRate($this->length->getUnit($productInfo['length_class_id'])) : 1;

            $unitPrice = $this->convert($product['price'], $currency, 3); // $product['price'] + $product['tax']

            $amount += $unitPrice * $product['quantity'];

            $invoiceItemsArr[] = [
                'ItemName'  => $product['name'],
                'Quantity'  => $product['quantity'],
                'UnitPrice' => $unitPrice,
                'weight'    => ($shippingMethod) ? $productInfo['weight'] * $weightRate : 0,
                'Width'     => ($shippingMethod) ? $productInfo['width'] * $dimensionRate : 0,
                'Height'    => ($shippingMethod) ? $productInfo['length'] * $dimensionRate : 0,
                'Depth'     => ($shippingMethod) ? $productInfo['height'] * $dimensionRate : 0,
            ];
        }

        //---------------------Gift User Created Vouchers
        $vouchers = $this->model_account_order->{$getVouchers}($orderId);
        if (!empty($vouchers)) {
            foreach ($vouchers as $voucher) {

                $unitPrice = $this->convert($voucher['amount'], $currency);

                $amount += $unitPrice;

                $invoiceItemsArr[] = array('ItemName' => $voucher['description'], 'Quantity' => 1, 'UnitPrice' => "$unitPrice", 'Weight' => '0', 'Width' => '0', 'Height' => '0', 'Depth' => '0');
            }
        }

        //---------------------shipping, tax, credit, handling, low_order_fee, coupon, reward, voucher, sub_total and total prices
        //other items in cart
        $items = $this->model_account_order->{$getTotals}($orderId);
        foreach ($items as $item) {
            if ($item['code'] != 'sub_total' && $item['code'] != 'total' && ($item['code'] != 'shipping' || ($shippingMethod == null && $item['code'] == 'shipping'))) {

                $unitPrice = $this->convert($item['value'], $currency);

                $amount += $unitPrice;

                $invoiceItemsArr[] = array('ItemName' => $item['title'], 'Quantity' => 1, 'UnitPrice' => "$unitPrice", 'Weight' => '0', 'Width' => '0', 'Height' => '0', 'Depth' => '0');
            }

            if ($item['code'] == 'shipping' && $shippingMethod) {
                $mfShipping = $this->currency->convert($item['value'], $this->config->get('config_currency'), $currency);
            }
        }

        return [
            'amount'       => $amount,
            'mfShipping'   => $mfShipping,
            'invoiceItems' => $invoiceItemsArr,
        ];
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function convert($value, $currencyCode, $decimal = 3) {
        $unitPrice = $this->currency->convert($value, $this->config->get('config_currency'), $currencyCode);
        return round($unitPrice, $decimal);
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function getSupplierInfo($amount) {

        $supplierCode = $this->config->get($this->oc['code'] . '_supplierCode');
        if (empty($supplierCode)) {
            return null;
        }

        return [[
        'SupplierCode'  => $supplierCode,
        'ProposedShare' => null,
        'InvoiceShare'  => $amount
        ]];
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------

    function displayError($errMessage) {

        if (version_compare(VERSION, '4.0', '>=')) {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode(['error' => $errMessage]));
            return;
        }
        $this->session->data['error'] = $errMessage;

        if ($this->config->get('quickcheckout_status') == 1) {
            $this->response->redirect($this->url->link('checkout/cart', '', true));
        }
        $this->response->redirect($this->url->link('checkout/checkout', '', true));
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function getOpenCartVersionInfo() {

        //-----------------------------------------
        if (version_compare(VERSION, '4.0', '>=')) {
            $connector = version_compare(VERSION, '4.0.2', '>=') ? '.' : '|';
            return[
                'path'             => "extension/myfatoorah/payment/$this->mfCode",
                'model'            => "model_extension_myfatoorah_payment_$this->mfCode",
                'callback'         => 'extension/myfatoorah/payment/myfatoorah' . $connector . 'callback',
                'code'             => "payment_$this->mfCode",
                'connector'        => $connector,
                'cssPath'          => 'extension/myfatoorah/catalog/view/stylesheet/myfatoorah.css',
                'addHistory'       => 'addHistory',
                'accountOrderFunc' => [
                    'getProducts' => 'getProducts',
                    'getVouchers' => 'getVouchers',
                    'getTotals'   => 'getTotals',
                ],
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '3.0', '>=')) {
            return[
                'path'             => "extension/payment/$this->mfCode",
                'model'            => "model_extension_payment_$this->mfCode",
                'callback'         => 'extension/payment/myfatoorah/callback',
                'code'             => "payment_$this->mfCode",
                'connector'        => '/',
                'cssPath'          => 'catalog/view/theme/default/stylesheet/myfatoorah.css',
                'addHistory'       => 'addOrderHistory',
                'accountOrderFunc' => [
                    'getProducts' => 'getOrderProducts',
                    'getVouchers' => 'getOrderVouchers',
                    'getTotals'   => 'getOrderTotals',
                ],
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '2.3', '>=')) {
            return[
                'path'             => "extension/payment/$this->mfCode",
                'model'            => "model_extension_payment_$this->mfCode",
                'callback'         => 'extension/payment/myfatoorah/callback',
                'code'             => $this->mfCode,
                'connector'        => '/',
                'cssPath'          => 'catalog/view/theme/default/stylesheet/myfatoorah.css',
                'addHistory'       => 'addOrderHistory',
                'accountOrderFunc' => [
                    'getProducts' => 'getOrderProducts',
                    'getVouchers' => 'getOrderVouchers',
                    'getTotals'   => 'getOrderTotals',
                ],
            ];
        }

        //-----------------------------------------
        return[
            'path'             => "payment/$this->mfCode",
            'model'            => "model_payment_$this->mfCode",
            'callback'         => 'payment/myfatoorah/callback',
            'code'             => $this->mfCode,
            'connector'        => '/',
            'cssPath'          => 'catalog/view/theme/default/stylesheet/myfatoorah.css',
            'addHistory'       => 'addOrderHistory',
            'accountOrderFunc' => [
                'getProducts' => 'getOrderProducts',
                'getVouchers' => 'getOrderVouchers',
                'getTotals'   => 'getOrderTotals',
            ],
        ];
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
}
