<?php

require_once 'myfatoorah_controller.php';

class ControllerExtensionPaymentMyfatoorahPg extends MyfatoorahController {

    protected $mfCode = 'myfatoorah_pg';

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function __construct($registry) {
        parent::__construct($registry);
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function index() {

        //don't continue if there is no order in the session
        if (empty($this->session->data['order_id'])) {
            return $this->displayError('Session has been expired please try again later.');
        }

        $data = $this->language->load($this->oc['path']);

        //to retun the name in db to its default 
        //version less than 4.0.2
        if (version_compare(VERSION, '4.0.2', '<')) {
            $this->db->query('UPDATE `' . DB_PREFIX . 'order` SET `payment_method`="' . $this->language->get('text_title') . '" WHERE `order_id`="' . (int) $this->session->data["order_id"] . '"');
        }
        //$this->db->query("UPDATE `" . DB_PREFIX . "order` a INNER JOIN `" . DB_PREFIX . "order` b ON a.order_id = b.order_id SET a.payment_method='MyFatoorah' where b.payment_method like '<div%' ");

        $data['mfVersion']      = MYFATOORAH_OC_PLUGIN_VERSION;
        $data['isOcVersion401'] = version_compare(VERSION, '4.0.2', '<') && version_compare(VERSION, '4.0', '>=');

        if (empty($_SERVER['HTTPS'])) {
            $data['mfError'] = $data['error_enable_ssl'];
        } else if ($this->currency->getValue($this->config->get('config_currency')) != 1) {
            $this->load->language('extension/shipping/myfatoorah');
            $data['mfError'] = $this->language->get('error_defult_currency_rate');
        } else {
            $data['action'] = 'index.php?route=' . $this->oc['path'] . $this->oc['connector'] . 'confirm';

            $data['displayTypes'] = $this->config->get($this->oc['code'] . '_payment_type');
            if ($data['displayTypes'] == 'multigateways') {
                $data = $this->fillMultigatewaysData($data);
            }
        }

        $themePath = (version_compare(VERSION, '2.2', '<')) ? 'default/template/' . $this->oc['path'] . '.tpl' : $this->oc['path'];
        return $this->load->view($themePath, $data);
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function confirm() {
        //check for order Id
        if (empty($this->session->data['order_id'])) {
            return $this->displayError('Session has been expired please try again later.');
        }
        $orderId = $this->session->data['order_id'];

        //check for order object
        $this->load->model('checkout/order');
        if (empty($this->model_checkout_order->getOrder($orderId))) {
            return $this->displayError('Order is not exist, please contact site admin! Or, you can logout and try again later.');
        }

        try {
            $curlData = $this->getPayload($orderId);

            $gatewayId = (empty($this->request->post['mfCardData'])) ? 'myfatoorah' : $this->request->post['mfCardData'];
            $sessionId = (empty($this->request->post['mfFormData'])) ? '' : $this->request->post['mfFormData'];

            $data = $this->mfObj->getInvoiceURL($curlData, $gatewayId, $orderId, $sessionId);
        } catch (Exception $ex) {
            return $this->displayError($ex->getMessage());
        }

        if (empty($data['invoiceId']) || empty($data['invoiceURL'])) {
            return $this->displayError('Something goes wrong');
        }

        //add history
        try {
            //to do add `invoice_no`, `invoice_prefix`  MyFatoorah-3313597 
            $this->db->query('UPDATE `' . DB_PREFIX . 'order` SET payment_custom_field="' . $this->db->escape(json_encode($data)) . '" WHERE `order_id`="' . (int) $orderId . '"');

            $initialStatus = $this->config->get($this->oc['code'] . '_initial_order_status_id');
            $this->model_checkout_order->{$this->oc['addHistory']}($orderId, $initialStatus); //We don't need to send a pending email to the customer.
        } catch (Exception $ex) {
            $logger = new Log('order_update_exception.log');
            $logger->write($ex->getMessage());
            $logger->write($ex->getTraceAsString());
        }

        if (version_compare(VERSION, '4.0', '>=')) {
            $this->response->addHeader('Content-Type: application/json');
            $this->response->setOutput(json_encode(['redirect' => $data['invoiceURL']]));
        } else {
            $this->response->redirect($data['invoiceURL']);
        }
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function fillMultigatewaysData($data) {
        try {
            $data['language'] = $this->language->get('code');

            $shippingCode   = ($this->session->data['shipping_method']['code']) ?? $this->session->data['shipping_method'];
            $shippingMethod = ($shippingCode == 'myfatoorah.dhl') ? 1 : (($shippingCode == 'myfatoorah.aramex') ? 2 : null);

            $cartData = $this->getCartData($shippingMethod);

            $data['paymentMethods'] = $this->mfObj->getCheckoutGateways(
                    ($cartData['amount'] + $cartData['mfShipping']),
                    $this->session->data['currency'],
                    $this->config->get($this->oc['code'] . '_isApplePayRegistered')
            );

            if (count($data['paymentMethods']['all']) == 0) {
                throw new Exception($this->language->get('error_no_mf_gateways'));
            }

            $viewObj = empty($this->journal3) ? $this : $this->journal3;
            $this->load->model($this->oc['path']);
            $this->{$this->oc['model']}->addScriptData($data['paymentMethods'], $viewObj);

            //add style
            if (isset($this->journal3)) {
                $this->journal3->document->addStyle($this->oc['cssPath']);
                $data['styles'] = [];
            } else {
                $this->document->addStyle($this->oc['cssPath']);
                $data['styles'] = $this->document->getStyles();
            }

            $data['cardHeight']  = '130';
            $data['tokenHeight'] = '130';
            $userDefinedField    = '';
            if (!empty($this->config->get($this->oc['code'] . '_saveCard')) && $this->customer->getId()) {
                $data['cardHeight']  = '180';
                $data['tokenHeight'] = '220';
                $userDefinedField    = 'CK-' . $this->customer->getId();
            }

            $data['session'] = $this->mfObj->getEmbeddedSession($userDefinedField);
        } catch (Exception $ex) {
            $data['mfError'] = $ex->getMessage();
        }
        return $data;
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
}
