<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);


class ControllerExtensionPaymentPaylink extends Controller
{
    private $callback;
    private $getInvoiceUrl;
    private $addInvoiceUrl;
    private $loginUrl;
    private $base_server_url;
    private $token_auth;

    public function index()
    {
        $this->load->language('extension/payment/paylink');

        $data['text_testmode'] = $this->language->get('text_testmode');
        $data['button_confirm'] = $this->language->get('button_confirm');

        $data['action'] = $this->url->link('extension/payment/paylink/confirmPayment', '', true);

        if ($this->config->get('payment_paylink_testmode') === '1') {
            $this->base_server_url = 'https://restpilot.paylink.sa';
        } else {
            $this->base_server_url = 'https://restapi.paylink.sa';
        }

        $this->getInvoiceUrl = $this->base_server_url . '/api/getInvoice';
        $this->addInvoiceUrl = $this->base_server_url . '/api/addInvoice';
        $this->loginUrl = $this->base_server_url . "/api/auth";

        $this->callback = $this->url->link('extension/payment/paylink/callback', '', true);


//        if ($this->config->get('payment_paylink_testmode')) {
//          //  $data['action'] = 'https://restpilot.paylink.sa';
//        } else {
//          //  $data['action'] = 'https://restapi.paylink.sa';
//        }

        $this->load->model('checkout/order');

        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        if ($order_info) {

            $data['business'] = $this->config->get('payment_paylink_email');
            $data['item_name'] = html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8');

            $data['products'] = array();

            foreach ($this->cart->getProducts() as $product) {
                $option_data = array();

                foreach ($product['option'] as $option) {
                    if ($option['type'] != 'file') {
                        $value = $option['value'];
                    } else {
                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                        if ($upload_info) {
                            $value = $upload_info['name'];
                        } else {
                            $value = '';
                        }
                    }

                    $option_data[] = array(
                        'name' => $option['name'],
                        'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value)
                    );
                }

                $data['products'][] = array(
                    'name' => htmlspecialchars($product['name']),
                    'model' => htmlspecialchars($product['model']),
                    'price' => $this->currency->format($product['price'], $order_info['currency_code'], false, false),
                    'quantity' => $product['quantity'],
                    'option' => $option_data,
                    'weight' => $product['weight']
                );
            }

            $data['discount_amount_cart'] = 0;

            $total = $this->currency->format($order_info['total'] - $this->cart->getSubTotal(), $order_info['currency_code'], false, false);

            if ($total > 0) {
                $data['products'][] = array(
                    'name' => $this->language->get('text_total'),
                    'model' => '',
                    'price' => $total,
                    'quantity' => 1,
                    'option' => array(),
                    'weight' => 0
                );
            } else {
                $data['discount_amount_cart'] -= $total;
            }

            $data['currency_code'] = $order_info['currency_code'];
            $data['first_name'] = html_entity_decode($order_info['payment_firstname'], ENT_QUOTES, 'UTF-8');
            $data['last_name'] = html_entity_decode($order_info['payment_lastname'], ENT_QUOTES, 'UTF-8');
            $data['address1'] = html_entity_decode($order_info['payment_address_1'], ENT_QUOTES, 'UTF-8');
            $data['address2'] = html_entity_decode($order_info['payment_address_2'], ENT_QUOTES, 'UTF-8');
            $data['city'] = html_entity_decode($order_info['payment_city'], ENT_QUOTES, 'UTF-8');
            $data['zip'] = html_entity_decode($order_info['payment_postcode'], ENT_QUOTES, 'UTF-8');
            $data['country'] = $order_info['payment_iso_code_2'];
            $data['email'] = $order_info['email'];
            $data['invoice'] = $this->session->data['order_id'] . ' - ' . html_entity_decode($order_info['payment_firstname'], ENT_QUOTES, 'UTF-8') . ' ' . html_entity_decode($order_info['payment_lastname'], ENT_QUOTES, 'UTF-8');
            $data['lc'] = $this->session->data['language'];
            $data['return'] = $this->url->link('checkout/success');
            $data['notify_url'] = $this->url->link('extension/payment/paylink/callback', '', true);
            $data['cancel_return'] = $this->url->link('checkout/checkout', '', true);

            if (!$this->config->get('payment_paylink_transaction')) {
                $data['paymentaction'] = 'authorization';
            } else {
                $data['paymentaction'] = 'sale';
            }

            $data['custom'] = $this->session->data['order_id'];

            return $this->load->view('extension/payment/paylink', $data);
        }
    }

    public function callback()
    {
        $this->load->language('extension/payment/paylink');

        // Array (  [orderNumber] => 9 [transactionNo] => 1619173224725 )
        if (isset($this->request->get['orderNumber']) && isset($this->request->get['transactionNo'])) {
            $transaction_no = $this->request->get['transactionNo'];
            $order_id = $this->request->get['orderNumber'];
            if (!$this->token_auth) {
                $this->token_auth = $this->login();
            }

            $curl = curl_init();
            if ($this->config->get('payment_paylink_testmode') === '1') {
                $getInvoice = 'https://restpilot.paylink.sa/api/getInvoice/';
            } else {
                $getInvoice = 'https://restapi.paylink.sa/api/getInvoice/';
            }

            curl_setopt_array($curl, array(
                CURLOPT_URL => $getInvoice . $transaction_no,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => array(
                    'accept: application/json;charset=UTF-8',
                    'Authorization: Bearer ' . $this->token_auth
                ),
            ));

            $response = json_decode(curl_exec($curl));
            curl_close($curl);
            $order_status = $response->orderStatus;

            // validating order status value
            // Debuge mode @todo add option to admin panel and check here ..

            $this->load->model('checkout/order');
            $order_info = $this->model_checkout_order->getOrder($order_id);
            if ($order_info) {
                if (isset($transaction_no)) {
                    $order_status_id = $this->config->get('config_order_status_id');

                    switch ($order_status) {
                        case 'Paid':
                            $order_status_id = $this->config->get('payment_paylink_paid_status_id');
                            break;
                        default :
                            $order_status_id = $this->config->get('payment_paylink_declined_status_id');
                            break;
                    }
                    if ($order_status == "Paid" || $order_status == "Completed") {
                        $text_message = sprintf($this->language->get('text_payment_success'));
                        $this->model_checkout_order->addOrderHistory($order_id, $order_status_id, $text_message, 1);
                        $this->response->redirect($this->url->link('checkout/success', '', true));
                    } else {
                        $order_payment_url = $response->url;
                        $order_payment_errors = $response->paymentErrors[0]->errorTitle;
                        $text_message = sprintf($this->language->get('text_payment_fail')) . '<br /' .
                            $order_payment_errors . '<br />' .
                            sprintf($this->language->get('text_payment_try'), $order_payment_url, $order_payment_url) . '<br />';

                        $this->model_checkout_order->addOrderHistory($order_id, $order_status_id, $text_message, 1);
                        $this->success($text_message);
                    }

                } else {
                    $this->model_checkout_order->addOrderHistory($order_id, $this->config->get('config_order_status_id'));
                    $this->response->redirect($this->url->link('checkout/checkout', '', true));
                }
            }
        } else {
            $this->log->write('There is no data token from PayLink.');
            $this->response->redirect($this->url->link('checkout/checkout', '', true));
        }

    }

    public function success($text_message)
    {
        if (isset($this->session->data['order_id'])) {
            $this->cart->clear();

            unset($this->session->data['shipping_method']);
            unset($this->session->data['shipping_methods']);
            unset($this->session->data['payment_method']);
            unset($this->session->data['payment_methods']);
            unset($this->session->data['guest']);
            unset($this->session->data['comment']);
            unset($this->session->data['order_id']);
            unset($this->session->data['coupon']);
            unset($this->session->data['reward']);
            unset($this->session->data['voucher']);
            unset($this->session->data['vouchers']);
            unset($this->session->data['totals']);
        }

        $this->document->setTitle($this->language->get('heading_title'));

        $data['breadcrumbs'] = array();

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_home'),
            'href' => $this->url->link('common/home')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_basket'),
            'href' => $this->url->link('checkout/cart')
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_checkout'),
            'href' => $this->url->link('checkout/checkout', '', true)
        );

        $data['breadcrumbs'][] = array(
            'text' => $this->language->get('text_success'),
            'href' => $this->url->link('checkout/success')
        );

        if ($this->customer->isLogged()) {
            // $data['text_message'] = sprintf($this->language->get('text_customer'), $this->url->link('account/account', '', true), $this->url->link('account/order', '', true), $this->url->link('account/download', '', true), $this->url->link('information/contact'));
            $data['text_message'] = $text_message;
        } else {
            //$data['text_message'] = sprintf($this->language->get('text_guest'), $this->url->link('information/contact'));
            $data['text_message'] = $text_message;
        }

        $data['continue'] = $this->url->link('common/home');

        $data['column_left'] = $this->load->controller('common/column_left');
        $data['column_right'] = $this->load->controller('common/column_right');
        $data['content_top'] = $this->load->controller('common/content_top');
        $data['content_bottom'] = $this->load->controller('common/content_bottom');
        $data['footer'] = $this->load->controller('common/footer');
        $data['header'] = $this->load->controller('common/header');

        $this->response->setOutput($this->load->view('common/success', $data));
    }


    public function check_paylink_response()
    {
        if (isset($order_id) && isset($transaction_no)) {
            if (!$this->token_auth) {
                $this->token_auth = $this->login();
            }

            if ($this->config->get('payment_paylink_testmode') === '1') {
                $InvoiceUrl = 'https://restpilot.paylink.sa/api/getInvoice';
            } else {
                $InvoiceUrl = 'https://restapi.paylink.sa/api/getInvoice';
            }

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $InvoiceUrl . '/' . $transaction_no,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_USERAGENT => '1.0',
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'GET',
                CURLOPT_HTTPHEADER => array(
                    'accept: application/json;charset=UTF-8',
                    'Authorization: Bearer ' . $this->token_auth
                ),
            ));

            $response = curl_exec($curl);
            curl_close($curl);

            $options = [
                'headers' => [
                    'Authorization' => 'Bearer ' . $this->token_auth
                ],
                'timeout' => 60,
                'httpversion' => '1.1',
                'user-agent' => '1.0',
            ];
            $response = wp_safe_remote_get($this->getInvoiceUrl . '/' . $transaction_no, $options);

            try {
                $order_status = sanitize_text_field(json_decode($response['body'])->{'orderStatus'});
                $order_status = mb_convert_case($order_status, MB_CASE_LOWER, "UTF-8");
                // validating order status value
                if ($order_status == "paid" || $order_status == "completed") {
                    $checkout_url = 'http://localhost/paylink.sa/';
                    // $order->payment_complete($transaction_no);
                    //  $this->cart->empty_cart();
                } else {
                    $msg['class'] = 'error';
                    $msg['message'] = $this->get_option('fail_msg');
                    if (function_exists('wc_add_notice')) {
                        wc_add_notice($msg['message'], $msg['class']);
                    } else {
                        //$woocommerce->add_error(esc_html($msg['message']));
                        // $woocommerce->set_messages();
                    }
                }
            } catch (Exception $ex) {
                error_log(print_r($ex, true));
            }
        }

    }

    private function login()
    {
        try {
            $app_id = $this->config->get('payment_paylink_app_id');
            $secret_key = $this->config->get('payment_paylink_secret_key');

            $login_parameter = array(
                'apiId' => $app_id,
                'secretKey' => $secret_key,
                'persistToken' => false
            );

            if ($this->config->get('payment_paylink_testmode') === '1') {
                $login_url = 'https://restpilot.paylink.sa/api/auth';
            } else {
                $login_url = 'https://restapi.paylink.sa/api/auth';
            }

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $login_url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($login_parameter),
                CURLOPT_HTTPHEADER => array(
                    'accept: */*',
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);

            if(!isset(json_decode($response)->id_token)) {
                $this->session->data['error'] = 'Bad credentials';
                $this->response->redirect($this->url->link('checkout/cart', '', true));
            }

            return json_decode($response)->id_token;

        } catch (Exception $ex) {
            // $this->log->write(print_r($ex, true));
            return false;
        }
    }

    function confirmPayment()
    {
        $order_id = 0;
        if (isset($this->session->data['order_id'])) {
            $order_id = $this->session->data['order_id'];
        } else {
            $order_id = 0;
        }

        $url = $this->generate_paylink_url($order_id);

        if ($url) {
            header("Location: " . $url);
            exit();
        } else {
            echo '<p>Something error. Please try again by refreshing the page</p>';
        }
    }


    private
    function generate_paylink_url($order_id)
    {
        $this->token_auth = $this->login();
        // validating token value.
        if ($this->token_auth) {
            return $this->createPaylinkInvoiceUrl($this->token_auth, $order_id);
        }
        return false;
    }

    private function createPaylinkInvoiceUrl($token, $order_id)
    {
        // $order = new WC_Order($order_id);
        $callBackUrl = $this->url->link('extension/payment/paylink/callback', '', true);
        $this->load->model('checkout/order');
        // $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        $order_info = $this->model_checkout_order->getOrder($order_id);

        $order_json = array();
        if ($order_info) {

            $data['item_name'] = html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8');
            $data['products'] = array();

            foreach ($this->cart->getProducts() as $product) {
                $option_data = array();

                foreach ($product['option'] as $option) {
                    if ($option['type'] != 'file') {
                        $value = $option['value'];
                    } else {
                        $upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

                        if ($upload_info) {
                            $value = $upload_info['name'];
                        } else {
                            $value = '';
                        }
                    }

                    $option_data[] = array(
                        'name' => $option['name'],
                        'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value)
                    );
                }

                $data['products'][] = array(
                    'name' => htmlspecialchars($product['name']),
                    'model' => htmlspecialchars($product['model']),
                    'price' => $this->currency->format($product['price'], $order_info['currency_code'], false, false),
                    'quantity' => $product['quantity'],
                    'option' => $option_data,
                    'weight' => $product['weight']
                );
            }

            $data['discount_amount_cart'] = 0;

            $total = $this->currency->format($order_info['total'] - $this->cart->getSubTotal(), $order_info['currency_code'], false, false);

            if ($total > 0) {
                $data['products'][] = array(
                    'name' => $this->language->get('text_total'),
                    'model' => '',
                    'price' => $total,
                    'quantity' => 1,
                    'option' => array(),
                    'weight' => 0
                );
            } else {
                $data['discount_amount_cart'] -= $total;
            }

            $data['currency_code'] = $order_info['currency_code'];
            $customerName = html_entity_decode($order_info['payment_firstname'] . ' ' . $order_info['payment_lastname'], ENT_QUOTES, 'UTF-8');
            $data['address1'] = html_entity_decode($order_info['payment_address_1'], ENT_QUOTES, 'UTF-8');
            $customerEmail = $order_info['email'];
            $lang = $this->session->data['language'];
            $note = html_entity_decode($order_info['payment_address_1'], ENT_QUOTES, 'UTF-8');
            $data['custom'] = $this->session->data['order_id'];
            $customerPhone = $order_info['telephone'];
            $total = $order_info['total'];

            $order_json = [
                'amount' => $total,
                'orderNumber' => $order_id,
                'callBackUrl' => $callBackUrl,
                'note' => $note,
                'clientEmail' => $customerEmail,
                'clientName' => $customerName,
                'clientMobile' => $customerPhone,
                'lang' => $lang,
                'products' => []
            ];
        }

        try {
            if ($this->config->get('payment_paylink_testmode') === '1') {
                $addInvoiceUrl = 'https://restpilot.paylink.sa/api/addInvoice';
            } else {
                $addInvoiceUrl = 'https://restapi.paylink.sa/api/addInvoice';
            }

            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $addInvoiceUrl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 60,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => json_encode($order_json),
                CURLOPT_HTTPHEADER => array(
                    'accept: application/json;charset=UTF-8',
                    'Authorization: Bearer ' . $token,
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            return json_decode($response)->url;
        } catch (Exception $exception) {
            // $this->log->write(print_r($exception, true));
            return false;
        }
    }

}