<?php

class ControllerExtensionPaymentThawani extends Controller {

    public function index() {
        $this->load->language('extension/payment/thawani');

        $data['text_pay_now'] = $this->language->get('text_pay_now');

        $this->load->model('checkout/order');

        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
        $currency_code = $order_info['currency_code'];
        $total = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);
        $merchant_order_id = $this->session->data['order_id'];
        $card_holder_name = $order_info['payment_firstname'] . ' ' . $order_info['payment_lastname'];
        $email = $order_info['email'];
        $phone = $order_info['telephone'];
        $city = $order_info['payment_city'];
        $address = $order_info['payment_address_1'];
        $postcode = $order_info['payment_postcode'];
        $state = $order_info['payment_zone'];
        $comment = $order_info['comment'];
        $country = $order_info['payment_iso_code_3'];
        $name = $this->config->get("config_name");
        $lang = $this->session->data['language'];
        $return_url = $this->url->link('extension/payment/thawani/callback');
        $success_url = $this->url->link('checkout/success', '', true);
        $failure_url = $this->url->link('checkout/failure', '', true);

        $data['products'] = array();
        $products_data = array();
        foreach ($this->cart->getProducts() as $product) {
            $amount = ($product['price'] * 1000);
            $quantiy = intval($product['quantity']);
            $name = utf8_substr($product['name'], 0, 30);
            array_push($products_data, array('name' => $name, 'unit_amount' => $amount, 'quantity' => $quantiy ));
        }
        
        
        $total_data = array();
        foreach ($this->model_checkout_order->getOrderTotals($this->session->data['order_id']) as $total) {
            $amount = ($total['value'] * 1000);
            $quantiy = '1';
            $name = utf8_substr($total['title'], 0, 30);
            if ($total['code'] ==  'total' ) {
                if ( $amount != '0.0000'){
                array_push($total_data, array('name' => $name, 'unit_amount' => $amount, 'quantity' => $quantiy ));
                }
            } else {
                
            }
        }
        
        $cart_data = array_merge($total_data);
        

        $products_data_json = json_encode($cart_data);

        if ($this->config->get('payment_thawani_test') == 'uat') 
            $url = 'https://uatcheckout.thawani.om'; //.$this->config->get('payment_thawani_merchant_id');
        else
            $url = 'https://checkout.thawani.om'; // .$this->config->get('payment_thawani_merchant_id');

            $api_key = $this->config->get('payment_thawani_secret_key');
            $publishable_key = $this->config->get('payment_thawani_publishable_key');


        $curl = curl_init();
        curl_setopt_array($curl, [
        CURLOPT_URL => $url . '/api/v1/checkout/session',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => "",
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => "POST",
        CURLOPT_POSTFIELDS => '{"client_reference_id": "order_'.$merchant_order_id.'","products": '.$products_data_json.',"success_url": "'.$return_url.'","cancel_url": "'.$failure_url.'","metadata": {"customer": "'.$card_holder_name.'","order_id": '.$merchant_order_id.'}}',
        CURLOPT_HTTPHEADER => [
            "Content-Type: application/json",
            "thawani-api-key:" .$api_key
        ],
        ]);

        $response = curl_exec($curl);
        $err = curl_error($curl);
        curl_close($curl);
        if ($err) {
            echo 'An error occured. Contact site administrator, please!';
        } else {
            $result = json_decode($response, true);
            $code = $result['code'];
            if($code == 2004 || $code == '2004') {
                $session_id = $result['data']['session_id'];
                $data['return_url'] = $url . "/pay/" . $session_id. '?key=' . $publishable_key;

                //echo $response;


            }
            //echo $response;

        }
        //echo $products_data_json;

        return $this->load->view('extension/payment/thawani', $data);
    }

    public function callback() {
        
        $this->load->model('checkout/order');

        $order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

        $merchant_order_id = $this->session->data['order_id'];

        $this->model_checkout_order->addOrderHistory($merchant_order_id, $this->config->get('payment_thawani_order_status_id'), 'Payment was made using thwani. thawani transaction id is '.$merchant_order_id, false);

        if($this->cart->hasProducts())
        $this->cart->clear();

        $success_url = $this->url->link('checkout/success', '', true);

        $this->response->redirect($this->url->link('checkout/success', 'order_id=' . $merchant_order_id));

        //echo $merchant_order_id;

    }
}