<?php
class ModelExtensionModuleLbtChallenger extends Model {

    private $error = array();

    /**
     * We are challenging Telephone here. Email should have been handled outside
     */
    public function check_approval_then_maybe_login_db() {

        $this->load->language('extension/module/lbt');

        $this->load->model('extension/module/lbt_dao');
        $this->load->model('account/customer');

        // Check if customer has been approved.
        $customer_info = $this->model_extension_module_lbt_dao->getCustomerByTelephone($this->request->post['email']);

        if ($customer_info && !$customer_info['status']) {
            $this->error['warning'] = $this->language->get('error_approved');
        }

        if (!$this->error) {

            if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] login by telephone: login = " . $this->request->post['email'] . " password: " . $this->request->post['password']);

            //The email field may contain the telephone :) we didn't change the name of the field in the template.
            if (!$this->model_extension_module_lbt_dao->get_customer_by_telephone_and_password_then_call_oc_login($this->request->post['email'], $this->request->post['password'])) {

                if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] login failure");

                $this->error['warning'] = $this->language->get('error_login_by_telephone');

                $this->model_account_customer->addLoginAttempt($this->request->post['email']);

            } else {
                if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] login success");
                $this->model_account_customer->deleteLoginAttempts($this->request->post['email']);
            }
        }

        return $this->error;
    }

}