<?php
/**@Component*/
class ModelExtensionModuleLbtDao extends Model {


    private function compact($telephone) {
        $search  = array(' ');
        $replace = array('');
        $compact = str_replace($search, $replace, $telephone);
        if ($this->config->get('lbt_cfg_log')) $this->log->write('[lbt] Compacted telephone is: ' . $compact);
        return $compact;
    }

    /**
     *
     */
    public function get_customer($tel_or_email) {

        $this->load->model('account/customer');


        //Login By Tel
        if ($this->config->get('lbt_cfg_mode') === "tel") {
            $customer_info = $this->get_customer_by_telephone($tel_or_email);
            return $customer_info;

        } else if ($this->config->get('lbt_cfg_mode') === "tel_or_email") {
            $customer_info = $this->get_customer_by_telephone($tel_or_email);
            if ($customer_info) {
                return $customer_info;
            }
        }

        $customer_info = $this->model_account_customer->getCustomerByEmail($tel_or_email);
        return $customer_info;
    }


    /**
     * catalog/model/account/customer.php
     * @deprecated
     * @see get_customer_by_telephone
     */
    public function getCustomerByTelephone($telephone) {
        return $this->get_customer_by_telephone($telephone);
    }

    public function get_customer_by_telephone($telephone) {
        $compact = $this->compact($telephone);

        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(telephone, ' ', '') = '" . $this->db->escape($compact) . "'");

        return $query->row;
    }

    /**
     * this function is the equivalent of the login function called : $this->customer->login
     * system/library/cart/customer.php
     */
    function get_customer_by_telephone_and_password_then_call_oc_login($telephone, $password, $override = false) {

        $compact = $this->compact($telephone);

        if ($override) {
            $customer_query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(telephone, ' ', '') = '" . $this->db->escape($compact) . "' AND status = '1'");

        } else {

            $sql = "SELECT * FROM " . DB_PREFIX . "customer WHERE REPLACE(telephone, ' ', '') = '" . $this->db->escape($compact) . "' AND (password = SHA1(CONCAT(salt, SHA1(CONCAT(salt, SHA1('" . $this->db->escape($password) . "'))))) OR password = '" . $this->db->escape(md5($password)) . "') AND status = '1'";

            if ($this->config->get('lbt_cfg_log')) $this->log->write('[lbt] SQL to login: ' . $sql);

            $customer_query = $this->db->query($sql);
        }

        /*
         *
         */
        if ($customer_query->num_rows) {
            return $this->call_oc_login($customer_query->row['email'], $password, $override);
        }

        return false;
    }

    public function call_oc_login($email, $password, $override = false) {
        if ($this->config->get('lbt_cfg_log')) $this->log->write('[lbt] Going to do oc login with email: ' . $email);
        $result = $this->customer->login($email, $password, $override);
        if ($this->config->get('lbt_cfg_log')) $this->log->write('[lbt] result: ' . $result);
        return $result;
    }

    /**
     * smshare listen to this event to send sms.
     * @param $country_iso_code_2 : is just here to be available for event parameters
     */
    public function edit_code($telephone, $code, $country_iso_code_2) {
        $comptact = $this->compact($telephone);
        $this->db->query("UPDATE `" . DB_PREFIX . "customer` SET code = '" . $this->db->escape($code) . "' WHERE REPLACE(telephone, ' ', '') = '" . $this->db->escape($comptact) . "'");
    }

    /**
     * smshare listen to this event to send sms.
     * @param $country_iso_code_2 : is just here to be available for event parameters
     */
    public function save_passwordless_code($telephone, $code, $customer_id, $redirect, $country_iso_code_2) {
        $sql = "INSERT INTO `" . DB_PREFIX . "tv_lbt_code` SET 
        `code` = '" . $code . "', 
        `telephone` = '" . $this->db->escape($telephone) . "', 
        `customer_id` = '" . $customer_id . "', 
        `redirect` = '" . $this->db->escape($redirect) . "', 
        `create_date` = NOW() 
        ";
        $this->db->query($sql);
    }

}