<?php
require_once DIR_SYSTEM . 'library/lbt/trait_lbt_customer.php';

/**@Component */
class ModelExtensionModuleLbtForgotten extends Model {

    use trait_lbt_customer;

    /**@Endpoint */
    public function on_forgotten_post() {

        $result = array();

        /*
         * validate first
         */
        $this->load->language('account/forgotten');
        $this->load->language('extension/module/lbt');


        if (!isset($this->request->post['email'])) {
            $result['error'] = $this->language->get('error_email');
            return $result;
        }


        /*
         *
         */
        if (preg_match('/^[^\@]+@.*.[a-z]{2,15}$/i', $this->request->post['email'])) {

            $this->load->model('account/customer');
            if (!$this->validate_by_email()) {
                $result['error'] = $this->error;
                return $result;
            }

            $this->model_account_customer->editCode($this->request->post['email'], token(40));
            $result['success'] = $this->language->get('text_success');
            return $result;

        } else {

            $customer_info = $this->validate_by_telephone($this->request->post['email']);
            if (!$customer_info) {
                $result['error'] = $this->error;
                return $result;
            }

            $iso_code_2 = $this->get_iso_code_by_customer_id($customer_info['customer_id']);

            $this->load->model('extension/module/lbt_dao');
            $this->model_extension_module_lbt_dao->edit_code($this->request->post['email'], token(10), $iso_code_2);

            $result['success'] = $this->language->get('text_success_reset_link');
            return $result;
        }
    }


    /**
     *
     */
    private function validate_by_email() {

        if (!$this->model_account_customer->getTotalCustomersByEmail($this->request->post['email'])) {
            $this->error = $this->language->get('error_email');
            return false;
        }

        // Check if customer has been approved.
        $customer_info = $this->model_account_customer->getCustomerByEmail($this->request->post['email']);

        if (!$this->validate_approval($customer_info)) {
            return false;
        }


        return true;
    }

}