<?php
class ModelExtensionModuleLbtNomod extends Model {

    public function get_error_if_telephone_is_not_unique($telephone) {

        if(! $this->config->get('lbt_cfg_tel_is_unique')) {
            return null;
        }


        if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] Telephone uniqueness feature is enabled. Going to check uniqueness...");


        $this->load->model('extension/module/lbt_dao');
        if ($this->model_extension_module_lbt_dao->getCustomerByTelephone($telephone)) {

            if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] Telephone already exists. Error message will be built and returned.");

            $this->load->language('extension/module/lbt');

            return $this->language->get('telephone_error_exists');
        }

        return null;

    }





}