<?php
class ModelExtensionModuleWebskyOtp extends Model
{

	public function addCustomer($data)
	{
		if (isset($data['customer_group_id']) && is_array($this->config->get('config_customer_group_display')) && in_array($data['customer_group_id'], $this->config->get('config_customer_group_display'))) {
			$customer_group_id = $data['customer_group_id'];
		} else {
			$customer_group_id = $this->config->get('config_customer_group_id');
		}

		$this->load->model('account/customer_group');

		$customer_group_info = $this->model_account_customer_group->getCustomerGroup($customer_group_id);

		if ($data['email'] == '') {
			$data['email'] = $data['telephone'] . '@test.com';
		}

		$this->db->query("INSERT INTO " . DB_PREFIX . "customer SET customer_group_id = '" . (int) $customer_group_id . "', store_id = '" . (int) $this->config->get('config_store_id') . "', language_id = '" . (int) $this->config->get('config_language_id') . "', email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "', newsletter = '" . (isset($data['newsletter']) ? (int) $data['newsletter'] : 0) . "', ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "', status = '" . (int) !$customer_group_info['approval'] . "', date_added = NOW()");
		$customer_id = $this->db->getLastId();

		return $customer_id;
	}

	public function register($data)
	{
		if (isset($data['customer_group_id']) && is_array($this->config->get('config_customer_group_display')) && in_array($data['customer_group_id'], $this->config->get('config_customer_group_display'))) {
			$customer_group_id = $data['customer_group_id'];
		} else {
			$customer_group_id = $this->config->get('config_customer_group_id');
		}

		$this->load->model('account/customer_group');

		$customer_group_info = $this->model_account_customer_group->getCustomerGroup($customer_group_id);

		$this->db->query("INSERT INTO " . DB_PREFIX . "customer SET customer_group_id = '" . (int) $customer_group_id . "', store_id = '" . (int) $this->config->get('config_store_id') . "', language_id = '" . (int) $this->config->get('config_language_id') . "', email = '" . $this->db->escape($data['email']) . "', telephone = '" . $this->db->escape($data['telephone']) . "', firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "', newsletter = '" . (isset($data['newsletter']) ? (int) $data['newsletter'] : 0) . "', ip = '" . $this->db->escape($this->request->server['REMOTE_ADDR']) . "', status = '" . (int) !$customer_group_info['approval'] . "', date_added = NOW()");
		$customer_id = $this->db->getLastId();

		return $customer_id;
	}
	public function fill_form($data)
	{
		$this->db->query("UPDATE " . DB_PREFIX . "customer SET firstname = '" . $this->db->escape($data['firstname']) . "', lastname = '" . $this->db->escape($data['lastname']) . "',email = '" . $this->db->escape($data['email']) . "' WHERE telephone = '" . $this->db->escape($data['telephone']) . "'");

	}



	public function getCustomerByEmail($email)
	{
		//	echo $email;
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE email = '" . $this->db->escape($email) . "'");
		if ($query->num_rows) {
			return $query->row;
		} else {
			return false;
		}
	}

	public function getCustomer($telephone)
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $this->db->escape($telephone) . "' OR email = '" . $this->db->escape($telephone) . "'");
		if ($query->num_rows) {
			return $query->row;
		} else {
			return false;
		}
	}
	public function getCustomerByTelephone($telephone)
	{
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer WHERE telephone = '" . $this->db->escape($telephone) . "'");
		if ($query->num_rows) {
			return $query->row;
		} else {
			return false;
		}
	}
	public function getCustomerByPassword($telephone)
	{
		$query = $this->db->query("SELECT `password` FROM " . DB_PREFIX . "customer WHERE telephone = '" . $this->db->escape($telephone) . "' OR email = '" . $this->db->escape($telephone) . "'");
		//print_r($query->num_rows);

		if ($query->num_rows) {
			
			return $query->row['password'];
			
		} else {
			return false;
		}
	}

	public function UpdateCode($telephone, $customer_id,$emailsend)
	{

		$code = $this->send($telephone,$emailsend);
		$this->session->data['code'] = $code;
   
		$this->db->query("UPDATE " . DB_PREFIX . "customer SET sms_verify_code = '" . (int) $code . "' WHERE customer_id = '" . (int) $customer_id . "'");

	}

	public function UpdateRegisterCode($telephone,$emailsend)
	{
		$code = $this->send($telephone,$emailsend);

		$this->session->data['code'] = $code;
	}

	public function send($telephone,$emailsend)
	{
		if ($this->config->get('module_websky_otp_test') == 1) {
			$code = substr($this->request->post['telephone'], -4);
			if($emailsend==1){
				$code='1111';
			}
		} else {
			$code = rand(1000, 10000);
			if($emailsend==1){
				$this->sendEmail($telephone, $code);
			}else {
                $this->sendSms($telephone, $code);
			}
			
		}
		return $code;

	}

	public function sendSms($telephone, $code)
	{
       if($this->checkSendSms($telephone)){
		require_once(DIR_SYSTEM . 'library/sms/otp.php');
		$this->otp = new Otp();

		$websky_otp_message = $this->config->get("module_websky_otp_message");
		$message = $websky_otp_message[$this->config->get('config_language_id')];
		$verify_message = str_replace("[otp]", $code, $message);
		$input_data = array("verification-code" => $code);

		if ($this->config->get("module_websky_otp_samane_sms") == 'smsir' || $this->config->get("module_websky_otp_samane_sms") == 'twilio') {
			$user = $this->config->get('module_websky_otp_sms_APIKey');
			$pass = $this->config->get('module_websky_otp_sms_SecretKey');
		} elseif ($this->config->get("module_websky_otp_samane_sms") == 'sabanovin') {
			$user = $this->config->get('module_websky_otp_sms_APIKey');
			$pass = $this->config->get('module_websky_otp_sms_APIKey');
		} else {
			$user = $this->config->get('module_websky_otp_sms_user');
			$pass = $this->config->get('module_websky_otp_sms_pass');
		}
		$from = $this->config->get('module_websky_otp_sms_from');
		$pattern_code = $this->config->get('module_websky_otp_paterncode');
		if (isset($pattern_code[$this->config->get("module_websky_otp_samane_sms")])) {
			$pattern_code_samane = $pattern_code[$this->config->get("module_websky_otp_samane_sms")];
		} else {
			$pattern_code_samane = 0;
		}
		if ($this->config->get("module_websky_otp_samane_sms") == 'melipayamak') {
			$input_data = $code;
			$from[$this->config->get("module_websky_otp_samane_sms")] = '';
		}
		if ($this->config->get("module_websky_otp_samane_sms") == 'smartwhatsapp') {
			$from[$this->config->get("module_websky_otp_samane_sms")] = '';
		}
		if ($this->config->get("module_websky_otp_samane_sms") == 'sendurl') {
			$input_data = $this->config->get("module_websky_otp_sms_send_url");
			$from[$this->config->get("module_websky_otp_samane_sms")] = '';
			$user[$this->config->get("module_websky_otp_samane_sms")] = '';
			$pass[$this->config->get("module_websky_otp_samane_sms")] = '';
		}

		$result = $this->otp->send($telephone, $verify_message, $user[$this->config->get("module_websky_otp_samane_sms")], $pass[$this->config->get("module_websky_otp_samane_sms")], $this->config->get('module_websky_otp_samane_sms'), $from[$this->config->get("module_websky_otp_samane_sms")], 'pattern', $pattern_code_samane, $input_data);
	  }
	}

	public function sendEmail($email, $code)
	{
       if($this->checkSendSms($email)){
		

		$websky_otp_message = $this->config->get("module_websky_otp_email_message");
		$websky_otp_message_subject = $this->config->get("module_websky_otp_email_subject");
		$subject = $websky_otp_message_subject[$this->config->get('config_language_id')];
		$messageotp = $websky_otp_message[$this->config->get('config_language_id')];
		$verify_message = str_replace("[otp]", $code, $messageotp);
		$message  = '<html dir="'.$this->language->get('direction').'" lang="'.$this->language->get('code').'">' . "\n";
					$message .= html_entity_decode($verify_message, ENT_QUOTES, 'UTF-8');
				
					$message .= '</html>' . "\n";
		
		 

		$mail = new Mail($this->config->get('config_mail_engine'));
		$mail->parameter = $this->config->get('config_mail_parameter');
		$mail->smtp_hostname = $this->config->get('config_mail_smtp_hostname');
		$mail->smtp_username = $this->config->get('config_mail_smtp_username');
		$mail->smtp_password = html_entity_decode($this->config->get('config_mail_smtp_password'), ENT_QUOTES, 'UTF-8');
		$mail->smtp_port = $this->config->get('config_mail_smtp_port');
		$mail->smtp_timeout = $this->config->get('config_mail_smtp_timeout');
		$mail->setTo($email);
		$mail->setFrom($this->config->get('config_email'));
		$mail->setSender(html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8'));
		$mail->setSubject($subject);
		$mail->setHtml($message);
		$mail->send(); 

		 }
	}

	public function checkSendSms($telephone)
	{
		if (!empty($this->request->server['HTTP_X_FORWARDED_FOR'])) {
			$ip = $this->request->server['HTTP_X_FORWARDED_FOR'];
		} elseif (!empty($this->request->server['REMOTE_ADDR'])) {
			$ip = $this->request->server['REMOTE_ADDR'];
		} elseif (!empty($this->request->server['HTTP_CLIENT_IP'])) {
			$ip = $this->request->server['HTTP_CLIENT_IP'];
		}
      

		
		 $config_time = $this->config->get("module_websky_otp_block_time");;
		if( $this->config->get("module_websky_otp_limit_time"))
			$count_submit = $this->config->get("module_websky_otp_limit_time");
         else 
		 $count_submit =3;
		 $login_info = $this->getLoginAttempts($ip);
		if ($login_info &&  time()- strtotime($login_info['date_modified']) < $config_time ) {
            $login_info['total']++;
			 if($login_info['total'] <= $count_submit ){
				$this->addLoginAttempt($ip);
				$this->session->data['last_submit']=time();
					unset($this->session->data['block_user']);
				return true;
			
			 }else {
			     	$this->session->data['block_user']=1;
				return false;
			
			 }
            
		} else {	
			$this->addLoginAttempt($ip);
			$this->session->data['last_submit']=time();
				unset($this->session->data['block_user']);
			return true;
		}
		
	

	
}
	public function addLoginAttempt($ip) {
		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "customer_login WHERE ip = '" . $this->db->escape($ip) . "'");

		if (!$query->num_rows) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "customer_login SET  ip = '" . $this->db->escape($ip) . "', total = 1, date_added = '" . $this->db->escape(date('Y-m-d H:i:s')) . "', date_modified = '" . $this->db->escape(date('Y-m-d H:i:s')) . "'");
		} else {
			$this->db->query("UPDATE " . DB_PREFIX . "customer_login SET total = (total + 1), date_modified = '" . $this->db->escape(date('Y-m-d H:i:s')) . "' WHERE customer_login_id = '" . (int)$query->row['customer_login_id'] . "'");
		}
	}

	public function getLoginAttempts($ip) {
		$query = $this->db->query("SELECT * FROM `" . DB_PREFIX . "customer_login` WHERE ip = '" . $this->db->escape($ip) . "'");

		return $query->row;
	}

	public function deleteLoginAttempts($ip) {
		$this->db->query("DELETE FROM `" . DB_PREFIX . "customer_login` WHERE WHERE ip = '" . $this->db->escape($ip) . "'");
	}



}