<?php

require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLoader.php';
require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLibrary.php';

class ModelExtensionPaymentMyfatoorahPG extends Model {

    private $mfCode = 'myfatoorah_pg';
    private $model  = 'payment';
    private $oc;

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function __construct($registry) {
        parent::__construct($registry);
        $this->oc = $this->getOpenCartVersionInfo();
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function getMethods() {

        return $this->getMethod();
    }

    //version less 4.0.2.x
    public function getMethod() {

        $this->language->load($this->oc['path']);

        $title = $this->language->get('text_title');

        //version 4.0.2.x
        $option_data[$this->mfCode] = [
            'code' => 'myfatoorah_pg.' . $this->mfCode,
            'name' => $title
        ];

        //allversions
        $methodData = [
            'code'       => $this->mfCode,
            'title'      => $title, //version less than 4.0.2.x
            'name'       => $title,
            'option'     => $option_data, //version more than 4.0.2.x
            'terms'      => '', //version less than 4.0.x
            'sort_order' => $this->config->get($this->oc['code'] . '_sort_order'),
        ];

        //if this is not the (admin @editOrder) view i.e. it is the (catalog @checkout) view
        if (!isset($this->session->data['api_id'])) {
            $types = $this->config->get($this->oc['code'] . '_payment_type');
            if ($types == 'multigateways') {
                $methodData = $this->getMethodData($methodData);
            }
        }

        //must be here after changing the title and name for the redirect, multigateways and single gateway
        if (version_compare(VERSION, '4.0', '>=')) {
            $filerPaymentOfShippingScript = '<script src="extension/myfatoorah/catalog/view/js/myfatoorah.js"></script>';
            $methodData['title']          .= $filerPaymentOfShippingScript;
            $methodData['name']           = $methodData['title'];
        }

        return $methodData;
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function getMethodData($methodData) {

        try {
            $isApRegistered = $this->config->get($this->oc['code'] . '_isApplePayRegistered');

            $isTest = !empty($this->config->get($this->oc['code'] . '_test'));
            $vcCode = $this->config->get($this->oc['code'] . '_countryMode');

            $mfConfig = [
                'apiKey' => $this->config->get($this->oc['code'] . '_apiKey'),
                'isTest' => $isTest,
                'vcCode' => $vcCode,
            ];

            $mfObj = new MyFatoorahPayment($mfConfig);

            $paymentMethods = $mfObj->getCachedCheckoutGateways($isApRegistered);

            $viewObj    = empty($this->journal3) ? $this : $this->journal3;
            $scriptHtml = $this->addScriptData($paymentMethods, $viewObj);

            $count = count($paymentMethods['all']);
            if ($count == 0) {
                $methodData['error'] = $this->language->get('error_no_mf_gateways');
            } else if ($count == 1) {
                $text = ($this->language->get('code') == 'ar') ? $paymentMethods['all'][0]->PaymentMethodAr : $paymentMethods['all'][0]->PaymentMethodEn;
                $icon = '<img style="width: 3.5rem; margin-inline-end: 0.313rem;" class="mf-pm-icon" src="' . $paymentMethods['all'][0]->ImageUrl . '" title="' . $text . '" alt="' . $text . '">';

                if (version_compare(VERSION, '4.0.2', '>=')) {
                    $methodData['title'] .= $scriptHtml;

                    $methodData['option'][$this->mfCode]['name'] = $text;
                } else {
                    $methodData['title'] = $icon . $text . $scriptHtml;
                }
            } else {
                $methodData['title'] .= $scriptHtml;
            }
        } catch (Exception $ex) {
            $methodData['error'] = $this->language->get($ex->getMessage());
        }

        return $methodData;
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function addScriptData($paymentMethods, $viewObj) {

        $scriptHtml = '';

        $isTest = !empty($this->config->get($this->oc['code'] . '_test'));
        $vcCode = $this->config->get($this->oc['code'] . '_countryMode');

        $countries = MyFatoorah::getMFCountries();
        $domain    = ($isTest) ? $countries[$vcCode]['testPortal'] : $countries[$vcCode]['portal'];

        if (!empty($paymentMethods['form'])) {
            $formScriptURL = "$domain/cardview/v2/session.js";
            $viewObj->document->addScript($formScriptURL);
            $scriptHtml    .= '<script src="' . $formScriptURL . '"></script>';
        }

        if (!empty($paymentMethods['ap'])) {
            $apScriptURL = "$domain/applepay/v2/applepay.js";
            $viewObj->document->addScript($apScriptURL);
            $scriptHtml  .= '<script src="' . $apScriptURL . '"></script>';
        }

        if (!empty($paymentMethods['gp'])) {
            $gpScriptURL = "$domain/googlepay/v1/googlepay.js";
            $viewObj->document->addScript($gpScriptURL);
            $scriptHtml  .= '<script src="' . $gpScriptURL . '"></script>';
        }

        return $scriptHtml;
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function getOpenCartVersionInfo() {

        //-----------------------------------------
        if (version_compare(VERSION, '4.0', '>=')) {
            return[
                'path' => "extension/myfatoorah/$this->model/$this->mfCode",
                'code' => $this->model . '_' . $this->mfCode,
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '3.0', '>=')) {
            return[
                'path' => "extension/$this->model/$this->mfCode",
                'code' => $this->model . '_' . $this->mfCode,
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '2.3', '>=')) {
            return[
                'path' => "extension/$this->model/$this->mfCode",
                'code' => $this->mfCode,
            ];
        }

        //-----------------------------------------
        return[
            'path' => "$this->model/$this->mfCode",
            'code' => $this->mfCode,
        ];
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
}
