<?php

require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLoader.php';
require_once DIR_SYSTEM . 'library/myfatoorah/MyfatoorahLibrary.php';

class ModelExtensionShippingMyfatoorah extends Model {

    private $mfCode = 'myfatoorah';
    private $model  = 'shipping';
    private $oc;

//---------------------------------------------------------------------------------------------------------------------------------------------------
    public function getQuote($address) {
        $this->oc = $this->getOpenCartVersionInfo();

        $this->load->language($this->oc['path']);
        $logger = new Log('myfatoorah_shipping.log');

        $shipping_methods = $this->config->get($this->oc['code'] . '_shipping');
        if (!$shipping_methods) {
            return [];
        }

        $isLog = !empty($this->config->get($this->oc['code'] . '_debug'));

        $mfConfig = [
            'apiKey'     => $this->config->get($this->oc['paymentCode'] . '_apiKey'),
            'isTest'     => !empty($this->config->get($this->oc['paymentCode'] . '_test')),
            'vcCode'     => $this->config->get($this->oc['paymentCode'] . '_countryMode'),
            'loggerObj'  => ($isLog) ? $logger : null,
            'loggerFunc' => 'write'
        ];

        $mfObj = new MyFatoorahShipping($mfConfig);

        $method_data = [
            'code'       => $this->mfCode,
            'title'      => $this->language->get('text_title'), //version less 4.0.2.x
            'name'       => $this->language->get('text_title'),
            'quote'      => [],
            'sort_order' => $this->config->get($this->oc['code'] . '_sort_order'),
            'error'      => false,
        ];

        if ($this->currency->getValue($this->config->get('config_currency')) != 1) {
            $method_data['error'] = $this->language->get('error_defult_currency_rate');
            return $method_data;
        }

        $shipping = ['1' => 'dhl', '2' => 'aramex'];

        try {
            $mfListObj    = new MyFatoorahList($mfConfig);
            $currencyRate = $mfListObj->getCurrencyRate($this->session->data['currency']);

            $invoiceItemsArr = $this->getShippingItems($mfObj);

            foreach ($shipping_methods as $key) {
                $carrierCode = $shipping[$key];
                $carrierName = strtoupper($this->language->get($carrierCode));

                $data = $mfObj->calculateShippingCharge($this->getShippingData($key, $invoiceItemsArr, $address));

                $realVal    = $data->Fees;
                $shipAmount = floor((int) ($realVal * $currencyRate * 1000)) / 1000;

                $carrierName .= $shipAmount == 0 ? $this->language->get('mf_free_shipping') : '';

                $method_data['quote'][$carrierCode] = [
                    'code'         => $this->mfCode . '.' . $carrierCode,
                    'title'        => $carrierName, //version less 4.0.2.x
                    'name'         => $carrierName,
                    'cost'         => $this->currency->convert($shipAmount, $this->session->data['currency'], $this->config->get('config_currency')),
                    'tax_class_id' => 0,
                    'mfid'         => $key,
                    'text'         => $this->currency->format($shipAmount, $this->session->data['currency'], 1.0000000)
                ];
            }

            if (!$method_data['quote']) {
                $method_data['error'] = $this->language->get('error_no_fees');
            }
        } catch (Exception $ex) {
            $method_data['error'] = $ex->getMessage();
        }

        return $method_data;
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function getShippingItems($mfObj) {
        $invoiceItemsArr = [];
        $products        = $this->cart->getProducts();
        foreach ($products as $product) {

            if ((float) $product['weight'] <= 0 || (float) $product['width'] <= 0 || (float) $product['length'] <= 0 || (float) $product['height'] <= 0) {
                $err = $this->language->get('error_dimensions_add') . $product['name'];
                $mfObj->log("DimensionsAdd - Error: $err");

                throw new Exception($err);
            }

            $weightRate        = $mfObj->getWeightRate($this->weight->getUnit($product['weight_class_id']));
            $dimensionRate     = $mfObj->getDimensionRate($this->length->getUnit($product['length_class_id']));
            $unitPrice         = $this->currency->convert($product['price'], $this->config->get('config_currency'), $this->session->data['currency']);
            $invoiceItemsArr[] = [
                'ProductName' => $product['name'],
                'Description' => $product['name'],
                'weight'      => $product['weight'] * $weightRate / $product['quantity'],
                'Width'       => $product['width'] * $dimensionRate,
                'Height'      => $product['length'] * $dimensionRate,
                'Depth'       => $product['height'] * $dimensionRate,
                'Quantity'    => $product['quantity'],
                'UnitPrice'   => round($unitPrice, 3),
            ];
        }

        return $invoiceItemsArr;
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------
    private function getShippingData($key, $invoiceItemsArr, $address) {
        $city     = !empty($address['city']) ? $address['city'] : $address['zone'];
        $postCode = $address['postcode'];
        $country  = $address['iso_code_2'];

        return [
            'ShippingMethod' => $key,
            'Items'          => $invoiceItemsArr,
            'CityName'       => $city,
            'PostalCode'     => $postCode,
            'CountryCode'    => $country
        ];
    }

//-----------------------------------------------------------------------------------------------------------------------------------------
    private function getOpenCartVersionInfo() {

        //-----------------------------------------
        if (version_compare(VERSION, '4.0', '>=')) {
            return[
                'path'        => "extension/myfatoorah/$this->model/$this->mfCode",
                'code'        => $this->model . '_' . $this->mfCode,
                'paymentCode' => 'payment_myfatoorah_pg',
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '3.0', '>=')) {
            return[
                'path'        => "extension/$this->model/$this->mfCode",
                'code'        => $this->model . '_' . $this->mfCode,
                'paymentCode' => 'payment_myfatoorah_pg',
            ];
        }

        //-----------------------------------------
        if (version_compare(VERSION, '2.3', '>=')) {
            return[
                'path'        => "extension/$this->model/$this->mfCode",
                'code'        => $this->mfCode,
                'paymentCode' => 'myfatoorah_pg',
            ];
        }

        //-----------------------------------------
        return[
            'path'        => "$this->model/$this->mfCode",
            'code'        => $this->mfCode,
            'paymentCode' => 'myfatoorah_pg',
        ];
    }

//---------------------------------------------------------------------------------------------------------------------------------------------------    
}
