<!-- mfVersion <?php echo $mfVersion; ?> -->
<div id="mf-errors" style="display:none;" data-mfVersion="<?php echo $mfVersion; ?>">
    <div class="alert alert-danger">
        <i id="mf-errorTxt" class="fa fa-exclamation-circle"></i>
    </div>
</div>
<script>
    function displayError(error) {
        document.getElementById('mf-errorTxt').innerHTML = '&nbsp;' + error;
        document.getElementById('mf-errors').style.display = 'block';
    }
</script>
<?php if (isset($mfError)): ?>
<script>
    displayError("<?php echo $mfError; ?>");
</script>
<?php else: ?>
<script>
    var quickCheckoutCardsBtn = false;
    function mfLoading() {
        if ('<?php echo $isOcVersion401; ?>' === '1') {
            $('#mfButtonCheckout').prop('disabled', true).addClass('loading');
        } else {
            $('#mfButtonCheckout').button('loading');
        }
    }

    function mfReset() {
        if ('<?php echo $isOcVersion401; ?>' === '1') {
            $('#mfButtonCheckout').prop('disabled', false).removeClass('loading');
        } else {
            $('#mfButtonCheckout').button('reset');
        }
    }
</script>
<form action="<?php echo $action; ?>" method="post" id="mfFormCheckout" data-mfVersion="<?php echo $mfVersion; ?>">
    <?php if ($displayTypes == 'multigateways'): ?>

    <!--Single Card Section-->
    <?php if ((count($paymentMethods['cards']) == 1 && count($paymentMethods['all']) == 1)): ?>
    <script>
        $(document).ready(function () {
            //single card button clicked
            $("#mfButtonCheckout").on('click', function () {
                mfSubmit("mfCardData", "<?php echo $paymentMethods['cards'][0]->PaymentMethodId; ?>");
            });
        });
    </script>

    <!--Multi Gateway Section-->
    <?php elseif (count($paymentMethods['all']) > 0): ?>
    <?php foreach ($styles as $style) { ?>
    <link href="<?php echo $style['href']; ?>" type="text/css" rel="<?php echo $style['rel']; ?>" media="<?php echo $style['media']; ?>" />
    <?php } ?>
    <div id="mf-paymentGateways" class="mf-payment-methods-container" data-mfVersion="<?php echo $mfVersion; ?>">
        <script>
            function mfEmbedCallback(response) {
                mfSubmit("mfFormData", response.sessionId);
            }
        </script>
        <p class="mf-grey-text"><?php echo $text_how_to_pay; ?></p>

        <!--Start ApplePay Section-->
        <?php if (count((array) $paymentMethods['ap']) > 0): ?>
        <div id="mf-sectionAP" style="margin-bottom: -10px;">
            <div id="mf-ap-element"></div>
            <script>
                $(document).ready(function () {
                    var mfApConfig = {
                        sessionId: "<?php echo $session->SessionId; ?>",
                        countryCode: "<?php echo $session->CountryCode; ?>",
                        currencyCode: "<?php echo $paymentMethods['ap']->GatewayData['GatewayCurrency']; ?>",
                        amount: "<?php echo $paymentMethods['ap']->GatewayData['GatewayTotalAmount']; ?>",
                        cardViewId: "mf-ap-element",
                        callback: mfEmbedCallback
                    };

                    myFatoorahAP.init(mfApConfig);
                });
            </script>
        </div>
        <?php endif; ?>
        <!--End ApplePay Section-->

        <!--Start Google Section-->
        <?php if (count((array) $paymentMethods['gp']) > 0): ?>
        <div id="mf-sectionGP" style="margin-bottom: -10px;">
            <div id="mf-gp-element"></div>
            <script>
                $(document).ready(function () {
                    var mfGpConfig = {
                        sessionId: "<?php echo $session->SessionId; ?>",
                        countryCode: "<?php echo $session->CountryCode; ?>",
                        currencyCode: "<?php echo $paymentMethods['gp']->GatewayData['GatewayCurrency']; ?>",
                        amount: "<?php echo $paymentMethods['gp']->GatewayData['GatewayTotalAmount']; ?>",
                        cardViewId: "mf-gp-element",
                        callback: mfEmbedCallback
                    };

                    myFatoorahGP.init(mfGpConfig);
                });
            </script>
        </div>
        <?php endif; ?>
        <!--End Google Section-->

        <!--Start Card Section-->
        <?php if (count($paymentMethods['cards']) > 0): ?>
        <div id="mf-sectionCard">
            <div class="mf-divider">
                <span>
                    <?php if (count((array) $paymentMethods['ap']) > 0 || count((array) $paymentMethods['gp']) > 0): ?>
                    <span id="mf-or-cardsDivider"><?php echo $text_or; ?></span>
                    <?php endif; ?>
                    <?php echo $text_pay_with; ?>
                </span>
            </div>

            <?php foreach ($paymentMethods['cards'] as $mfCard) { ?>
            <?php $mfPaymentTitle = (($language == 'ar') ? ($mfCard->PaymentMethodAr) : ($mfCard->PaymentMethodEn)); ?>
            <div class="mf-card-container" mfCardId="<?php echo $mfCard->PaymentMethodId; ?>" data-mfCardCode="<?php echo $mfCard->PaymentMethodCode; ?>">
                <div class="mf-row-container">
                    <img class="mf-payment-logo" src="<?php echo $mfCard->ImageUrl; ?>" title="<?php echo $mfPaymentTitle; ?>" alt="<?php echo $mfPaymentTitle; ?>"/>
                    <h5 class="mf-payment-text mf-card-title"><?php echo $mfPaymentTitle; ?></h5>
                </div>
                <h5 class="mf-payment-text">
                    <?php echo $mfCard->GatewayData['GatewayTotalAmount'] . ' ' . $mfCard->GatewayData['GatewayTransCurrency'][$language]; ?>
                </h5>
            </div>
            <?php } ?>
            <script>
                $(document).ready(function () {
                    //card button clicked
                    $("[mfCardId]").on('click', function () {
                        mfSubmit("mfCardData", $(this).attr('mfCardId'));
                    });
                });
            </script>
        </div>
        <?php endif; ?>
        <!--End Card Section-->

        <!--Start Form Section-->
        <?php if (count($paymentMethods['form']) > 0): ?>
        <div class="mf-divider">
            <span>
                <?php if (count((array) $paymentMethods['ap']) > 0 || count((array) $paymentMethods['gp']) > 0 || count($paymentMethods['cards']) > 0): ?>
                <span id="mf-or-formDivider"><?php echo $text_or; ?></span>
                <?php endif; ?>
                <?php echo $text_insert_card; ?>
            </span>
        </div>

        <div id="mf-form-element"></div>
        <script>
            $(document).ready(function () {

                var mfConfig = {
                    countryCode: "<?php echo $session->CountryCode; ?>",
                    sessionId: "<?php echo $session->SessionId; ?>",
                    cardViewId: "mf-form-element",
                    //onCardBinChanged: handleBinChanges,
                    // The following style is optional.
                    style: {
                        hideCardIcons: false,
                        direction: "<?php echo (($language == 'ar') ? ('rtl') : ('ltr')); ?>",
                        cardHeight: "<?php echo $cardHeight; ?>",
                        tokenHeight: "<?php echo $tokenHeight; ?>",
                        input: {
                            color: "black",
                            fontSize: "13px",
                            fontFamily: "sans-serif",
                            inputHeight: "32px",
                            inputMargin: "-1px",
                            borderColor: "c7c7c7",
                            borderWidth: "1px",
                            borderRadius: "0px",
                            boxShadow: "",
                            placeHolder: {
                                holderName: "<?php echo $text_placeHolder_holderName; ?>",
                                cardNumber: "<?php echo $text_placeHolder_cardNumber; ?>",
                                expiryDate: "<?php echo $text_placeHolder_expiryDate; ?>",
                                securityCode: "<?php echo $text_placeHolder_securityCode; ?>"
                            }
                        },
                        text: {
                            saveCard: "<?php echo $text_save_card; ?>",
                            addCard: "<?php echo $text_add_card; ?>",
                            deleteAlert: {
                                title: "<?php echo $text_deleteAlert_title; ?>",
                                message: "<?php echo $text_deleteAlert_message; ?>",
                                confirm: "<?php echo $text_deleteAlert_confirm; ?>",
                                cancel: "<?php echo $text_deleteAlert_cancel; ?>"
                            }
                        },
                        label: {
                            display: false,
                            color: "black",
                            fontSize: "13px",
                            fontWeight: "normal",
                            fontFamily: "sans-serif",
                            text: {
                                holderName: "<?php echo $text_label_holderName; ?>",
                                cardNumber: "<?php echo $text_label_cardNumber; ?>",
                                expiryDate: "<?php echo $text_label_expiryDate; ?>",
                                securityCode: "<?php echo $text_label_securityCode; ?>"
                            }
                        },
                        error: {
                            borderColor: "red",
                            borderRadius: "8px",
                            boxShadow: "0px"
                        }
                    }
                };

                myFatoorah.init(mfConfig);
                window.addEventListener("message", myFatoorah.recievedMessage);

                //form button clicked
                $('#mfButtonCheckout').on('click', function (e) {
                    $('#mfErrorDiv').remove();
                    e.preventDefault(); // Disable "Place Order" button

                    mfLoading();
                    myFatoorah.submit().then(
                            function (response) {
                                // On success
                                mfSubmit("mfFormData", response.sessionId);
                            },
                            function (error) {
                                // In case of errors
                                mfReset();
                                $('#mf-errorTxt').html('&nbsp;' + error);
                                $('#mf-form-element').before('<div id="mfErrorDiv">' + $('#mf-errors').html() + '</div>');

                                //for different themes
                                $('.journal-loading-overlay').hide();
                                $('#quick-checkout-button-confirm').removeClass('disabled');
                                $('#quick-checkout-button-confirm').removeAttr('disabled');
                            }
                    );
                });
            });
        </script>
        <?php endif; ?>
    </div>
    <script>
        $(document).ready(function () {
            if (window.ApplePaySession) {
                return;
            }

            //remove ap if registered
            document.getElementById('mf-sectionAP')?.remove();

            var mfGpElement = document.getElementById('mf-sectionGP');
            if (!mfGpElement) {
                document.getElementById('mf-or-cardsDivider')?.remove();
            }

            //remove ap as a card
            var mfCardCodeAps = document.querySelectorAll('[data-mfCardCode="ap"]');
            mfCardCodeAps.forEach(element => {
                element.remove();
            });

            //are there any cards left?
            var mfCardContainer = document.querySelectorAll('[data-mfCardCode]');
            if (mfCardContainer.length === 0) {
                document.getElementById('mf-sectionCard')?.remove();
                if (!mfGpElement) {
                    document.getElementById('mf-or-formDivider')?.remove();
                }

                if (!document.getElementById('mf-ap-element') && !document.getElementById('mf-gp-element') && !document.getElementById('mf-form-element')) {
                    document.getElementById('mf-paymentGateways')?.remove();
                    displayError("<?php echo $error_no_mf_gateways; ?>");
                }
            }
        });
    </script>
    <?php endif; ?>
    <!--End Form Section-->


    <?php endif; ?>
    <?php if (($displayTypes == 'myfatoorah') || (count($paymentMethods['all']) == 0) || (count($paymentMethods['form']) > 0) || ((count($paymentMethods['cards']) == 1 && count($paymentMethods['all']) == 1))): ?>
    <div class="buttons" data-mfVersion="<?php echo $mfVersion; ?>">
        <div class="pull-right">
            <input id="mfButtonCheckout" type="submit" class="btn btn-primary" value="<?php echo $button_confirm; ?>" data-loading-text="Loading..." />
        </div>
    </div>
    <?php endif; ?>
</form>
<?php endif; ?>
<script>
    function mfSubmit(name, value) {

        mfLoading();
        $('#mfFormCheckout').append('<input type="hidden" name="' + name + '" value="' + value + '">');

        if ($("#quick-checkout-button-confirm").length > 0) {
            quickCheckoutCardsBtn = true;
            $("#quick-checkout-button-confirm").click();
        } else {
            $('#mfFormCheckout').submit(); // Trigger submit
        }
    }
</script>