<?php
class ControllerAccountLogin extends Controller {
	private $error = array();

	public function index() {
		$this->load->model('account/customer');

		// Login override for admin users
		if (!empty($this->request->get['token'])) {
			$this->customer->logout();
			$this->cart->clear();

			unset($this->session->data['order_id']);
			unset($this->session->data['payment_address']);
			unset($this->session->data['payment_method']);
			unset($this->session->data['payment_methods']);
			unset($this->session->data['shipping_address']);
			unset($this->session->data['shipping_method']);
			unset($this->session->data['shipping_methods']);
			unset($this->session->data['comment']);
			unset($this->session->data['coupon']);
			unset($this->session->data['reward']);
			unset($this->session->data['voucher']);
			unset($this->session->data['vouchers']);

			$customer_info = $this->model_account_customer->getCustomerByToken($this->request->get['token']);

			if ($customer_info && $this->customer->login($customer_info['email'], '', true)) {
				// Default Addresses
				$this->load->model('account/address');

				if ($this->config->get('config_tax_customer') == 'payment') {
					$this->session->data['payment_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
				}

				if ($this->config->get('config_tax_customer') == 'shipping') {
					$this->session->data['shipping_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
				}


            if (defined('JOURNAL3_ACTIVE')) {
                if (\Journal3\Utils\Request::isAjax()) {
                    echo json_encode(array(
                        'status' => 'success',
                        'customer' => $this->customer->isLogged()
                    ), true);

                    exit;
                }
            }
            
				$this->response->redirect($this->url->link('account/account', '', true));
			}
		}

		if ($this->customer->isLogged()) {

            if (defined('JOURNAL3_ACTIVE')) {
                if (\Journal3\Utils\Request::isAjax()) {
                    echo json_encode(array(
                        'status' => 'success',
                        'customer' => $this->customer->isLogged()
                    ), true);

                    exit;
                }
            }
            
			$this->response->redirect($this->url->link('account/account', '', true));
		}

		$this->load->language('account/login');

		$this->document->setTitle($this->language->get('heading_title'));

             if( $this->config->get('module_websky_otp_status')){    
				if (defined('JOURNAL3_ACTIVE') && $this->journal3->document->isPopup()) {
					 $this->response->redirect($this->url->link('extension/module/websky_otp&popup=login', '', true));
				}else {
					 $this->response->redirect($this->url->link('extension/module/websky_otp', '', true));
               }
            }
				

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			// Unset guest
			unset($this->session->data['guest']);

			// Default Shipping Address
			$this->load->model('account/address');

			if ($this->config->get('config_tax_customer') == 'payment') {
				$this->session->data['payment_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
			}

			if ($this->config->get('config_tax_customer') == 'shipping') {
				$this->session->data['shipping_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
			}

			// Wishlist
			if (isset($this->session->data['wishlist']) && is_array($this->session->data['wishlist'])) {
				$this->load->model('account/wishlist');

				foreach ($this->session->data['wishlist'] as $key => $product_id) {
					$this->model_account_wishlist->addWishlist($product_id);

					unset($this->session->data['wishlist'][$key]);
				}
			}

			// Added strpos check to pass McAfee PCI compliance test (http://forum.opencart.com/viewtopic.php?f=10&t=12043&p=151494#p151295)
			if (isset($this->request->post['redirect']) && $this->request->post['redirect'] != $this->url->link('account/logout', '', true) && (strpos($this->request->post['redirect'], $this->config->get('config_url')) !== false || strpos($this->request->post['redirect'], $this->config->get('config_ssl')) !== false)) {

            if (defined('JOURNAL3_ACTIVE')) {
                if (\Journal3\Utils\Request::isAjax()) {
                    echo json_encode(array(
                        'status' => 'success',
                        'customer' => $this->customer->isLogged()
                    ), true);

                    exit;
                }
            }
            
				$this->response->redirect(str_replace('&amp;', '&', $this->request->post['redirect']));
			} else {

            if (defined('JOURNAL3_ACTIVE')) {
                if (\Journal3\Utils\Request::isAjax()) {
                    echo json_encode(array(
                        'status' => 'success',
                        'customer' => $this->customer->isLogged()
                    ), true);

                    exit;
                }
            }
            
				$this->response->redirect($this->url->link('account/account', '', true));
			}
		}


            if($this->request->server['REQUEST_METHOD'] == 'POST' && $this->error){
                if (defined('JOURNAL3_ACTIVE')) {
                    if (\Journal3\Utils\Request::isAjax() && $this->error) {
                        echo json_encode(array(
                            'status' => 'error',
                            'response' => $this->error
                        ), true);

                        exit;
                    }
                }
            }
            
		$data['breadcrumbs'] = array();

        $this->load->model('extension/module/lbt_xyz');
        $lbt_data = $this->model_extension_module_lbt_xyz->get_my_data();
        $data     = array_merge($data, $lbt_data);

        $data['lbt_fragment_at_login'] = $this->load->controller("extension/module/lbt_code_fragment/render", $data);
            

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/home')
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_account'),
			'href' => $this->url->link('account/account', '', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_login'),
			'href' => $this->url->link('account/login', '', true)
		);

		if (isset($this->session->data['error'])) {
			$data['error_warning'] = $this->session->data['error'];

			unset($this->session->data['error']);
		} elseif (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['action'] = $this->url->link('account/login', '', true);
		$data['register'] = $this->url->link('account/register', '', true);
		$data['forgotten'] = $this->url->link('account/forgotten', '', true);

		// Added strpos check to pass McAfee PCI compliance test (http://forum.opencart.com/viewtopic.php?f=10&t=12043&p=151494#p151295)
		if (isset($this->request->post['redirect']) && (strpos($this->request->post['redirect'], $this->config->get('config_url')) !== false || strpos($this->request->post['redirect'], $this->config->get('config_ssl')) !== false)) {
			$data['redirect'] = $this->request->post['redirect'];
		} elseif (isset($this->session->data['redirect'])) {
			$data['redirect'] = $this->session->data['redirect'];

			unset($this->session->data['redirect']);
		} else {
			$data['redirect'] = '';
		}

		if (isset($this->session->data['success'])) {
			$data['success'] = $this->session->data['success'];

			unset($this->session->data['success']);
		} else {
			$data['success'] = '';
		}

		if (isset($this->request->post['email'])) {
			$data['email'] = $this->request->post['email'];
		} else {
			$data['email'] = '';
		}

		if (isset($this->request->post['password'])) {
			$data['password'] = $this->request->post['password'];
		} else {
			$data['password'] = '';
		}


				$this->load->language('extension/module/waclient');
				$data['waclient_status'] = $this->config->get('module_waclient_status');
				$data['loginotpstatus'] = $this->config->get('module_waclient_loginbtnstatus');
				$data['waclient_countrycode_phone'] = $this->config->get('module_waclient_countrycode_phone');

				$waclientsotplogin = $this->config->get('module_waclient_loginotp');

				if(!empty($waclientsotplogin[$this->config->get('config_language_id')]['loginbtntext'])){
					$data['entry_loginotp'] = $waclientsotplogin[$this->config->get('config_language_id')]['loginbtntext'];
				} else {
					$data['entry_loginotp'] = $this->language->get('entry_loginotp');
				}

				$data['waclient_otplogin'] = $this->load->controller('extension/waclient/verifytelephone', array('location'=>'accountlogin'));
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

		$this->response->setOutput($this->load->view('account/login', $data));
	}

	protected function validate() {
		// Check how many login attempts have been made.
		$login_info = $this->model_account_customer->getLoginAttempts($this->request->post['email']);

		if ($login_info && ($login_info['total'] >= $this->config->get('config_login_attempts')) && strtotime('-1 hour') < strtotime($login_info['date_modified'])) {
			$this->error['warning'] = $this->language->get('error_attempts');
		}



        //Login By Tel
        if($this->config->get('lbt_cfg_mode') === "tel"){
            $this->load->model('extension/module/lbt_challenger');
            $this->error = $this->model_extension_module_lbt_challenger->check_approval_then_maybe_login_db();
            return !$this->error;

        }else if ($this->config->get('lbt_cfg_mode') === "tel_or_email"){
            $this->load->model('extension/module/lbt_challenger');
            $lbt_error = $this->model_extension_module_lbt_challenger->check_approval_then_maybe_login_db();
            if(! $lbt_error){
                return !$this->error;

            }else{  //continue below ↓
                if($this->config->get('lbt_cfg_log')) $this->log->write("[lbt] Mode: tel_or_email. Tel login failed. Let's try with email");
            }
        }
        //if lbt_cfg_mode === "email", continue below also ↓

            
		// Check if customer has been approved.
		$customer_info = $this->model_account_customer->getCustomerByEmail($this->request->post['email']);

		if ($customer_info && !$customer_info['status']) {
			$this->error['warning'] = $this->language->get('error_approved');
		}

		if (!$this->error) {
			if (!$this->customer->login($this->request->post['email'], $this->request->post['password'])) {
				$this->error['warning'] = $this->language->get('error_login');


                if(isset($lbt_error)){
                    $this->load->language('extension/module/lbt');
                    $this->error['warning'] = $this->language->get('error_login_by_tel_or_email');
                }

            

				$this->model_account_customer->addLoginAttempt($this->request->post['email']);
			} else {
				$this->model_account_customer->deleteLoginAttempts($this->request->post['email']);
			}
		}


            if (defined('JOURNAL3_ACTIVE')) {
                if (\Journal3\Utils\Request::isAjax() && $this->error) {
                    echo json_encode(array(
                        'status' => 'error',
                        'response' => $this->error
                    ), true);

                    exit;
                }
            }
            
		return !$this->error;
	}
}
