<?php
class ControllerCheckoutLogin extends Controller {
	public function index() {
		$this->load->language('checkout/checkout');

		$data['checkout_guest'] = ($this->config->get('config_checkout_guest') && !$this->config->get('config_customer_price') && !$this->cart->hasDownload());

		if (isset($this->session->data['account'])) {
			$data['account'] = $this->session->data['account'];
		} else {
			$data['account'] = 'register';
		}

		$data['forgotten'] = $this->url->link('account/forgotten', '', true);


            $this->load->model('extension/module/lbt_xyz');
            $lbt_data = $this->model_extension_module_lbt_xyz->get_my_data();
            $data = array_merge($data, $lbt_data);

            


				$this->load->language('extension/module/waclient');

				$data['waclient_status'] = $this->config->get('module_waclient_status');
				$data['loginotpstatus'] = $this->config->get('module_waclient_loginbtnstatus');
				$data['resendtime'] = $this->config->get('module_waclient_resendtime');
				$data['waclient_countrycode_phone'] = $this->config->get('module_waclient_countrycode_phone');

				$waclientsotplogin = $this->config->get('module_waclient_loginotp');

				if(!empty($waclientsotplogin[$this->config->get('config_language_id')]['loginbtntext'])){
					$data['entry_loginotp'] = $waclientsotplogin[$this->config->get('config_language_id')]['loginbtntext'];
				} else {
					$data['entry_loginotp'] = $this->language->get('entry_loginotp');
				}

				$data['waclient_otplogin'] = $this->load->controller('extension/waclient/verifytelephone', array('location'=>'checkoutlogin'));
		$this->response->setOutput($this->load->view('checkout/login', $data));
	}

	public function save() {
		$this->load->language('checkout/checkout');

		$json = array();

		if ($this->customer->isLogged()) {
			$json['redirect'] = $this->url->link('checkout/checkout', '', true);
		}

		if ((!$this->cart->hasProducts() && empty($this->session->data['vouchers'])) || (!$this->cart->hasStock() && !$this->config->get('config_stock_checkout'))) {
			$json['redirect'] = $this->url->link('checkout/cart');
		}

		if (!$json) {
			$this->load->model('account/customer');

			// Check how many login attempts have been made.
			$login_info = $this->model_account_customer->getLoginAttempts($this->request->post['email']);

			if ($login_info && ($login_info['total'] >= $this->config->get('config_login_attempts')) && strtotime('-1 hour') < strtotime($login_info['date_modified'])) {
				$json['error']['warning'] = $this->language->get('error_attempts');
			}

			// Check if customer has been approved.
			
            $this->load->model('extension/module/lbt_dao');
            $this->load->language('extension/module/lbt');

            $customer_info = $this->model_extension_module_lbt_dao->get_customer($this->request->post['email']);
            

			if ($customer_info && !$customer_info['status']) {
				$json['error']['warning'] = $this->language->get('error_approved');
			}

			if (!isset($json['error'])) {
				

                if($this->config->get('lbt_cfg_mode') === "tel" && ! $this->model_extension_module_lbt_dao->get_customer_by_telephone_and_password_then_call_oc_login($this->request->post['email'], $this->request->post['password'])){
                    $json['error']['warning'] = $this->language->get('error_login_by_telephone');

                    $this->model_account_customer->addLoginAttempt($this->request->post['email']);

                }else if ($this->config->get('lbt_cfg_mode') === "tel_or_email"){

                    $login_tel_success = $this->model_extension_module_lbt_dao->get_customer_by_telephone_and_password_then_call_oc_login($this->request->post['email'], $this->request->post['password']);
                    $login_email_success = $this->customer->login($this->request->post['email'], $this->request->post['password']);

                    if(!$login_tel_success && !$login_email_success) {
                        $json['error']['warning'] = $this->language->get('error_login_by_tel_or_email');

                        $this->model_account_customer->addLoginAttempt($this->request->post['email']);
                    }

                }else if ($this->config->get('lbt_cfg_mode') === "email" && !$this->customer->login($this->request->post['email'], $this->request->post['password'])){

            
					$json['error']['warning'] = $this->language->get('error_login');

					$this->model_account_customer->addLoginAttempt($this->request->post['email']);
				} else {
					$this->model_account_customer->deleteLoginAttempts($this->request->post['email']);
				}
			}
		}

		if (!$json) {
			// Unset guest
			unset($this->session->data['guest']);

			// Default Shipping Address
			$this->load->model('account/address');

			if ($this->config->get('config_tax_customer') == 'payment') {
				$this->session->data['payment_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
			}

			if ($this->config->get('config_tax_customer') == 'shipping') {
				$this->session->data['shipping_address'] = $this->model_account_address->getAddress($this->customer->getAddressId());
			}

			// Wishlist
			if (isset($this->session->data['wishlist']) && is_array($this->session->data['wishlist'])) {
				$this->load->model('account/wishlist');

				foreach ($this->session->data['wishlist'] as $key => $product_id) {
					$this->model_account_wishlist->addWishlist($product_id);

					unset($this->session->data['wishlist'][$key]);
				}
			}

			$json['redirect'] = $this->url->link('checkout/checkout', '', true);
		}

		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput(json_encode($json));
	}
}
