<?php
/**
 * @package		OpenCart
 * @author		Daniel Kerr
 * @copyright	Copyright (c) 2005 - 2017, OpenCart, Ltd. (https://www.opencart.com/)
 * @license		https://opensource.org/licenses/GPL-3.0
 * @link		https://www.opencart.com
*/

/**
* Mail class
*/

  use PHPMailer\PHPMailer\PHPMailer;
  use PHPMailer\PHPMailer\Exception;
  include_once(DIR_SYSTEM . 'library/phpmailer/PHPMailer.php');
  include_once(DIR_SYSTEM . 'library/phpmailer/Exception.php');
      
class Mail {
	protected $to;
	protected $from;
	protected $sender;
	protected $reply_to;
	protected $subject;
	protected $text;
	protected $html;
	protected $attachments = array();
	public $parameter;

	/**
	 * Constructor
	 *
	 * @param	string	$adaptor
	 *
 	*/
	public function __construct($adaptor = 'mail') {
		$class = 'Mail\\' . $adaptor;
		
		if (class_exists($class)) {
			$this->adaptor = new $class();
		} else {
			trigger_error('Error: Could not load mail adaptor ' . $adaptor . '!');
			exit();
		}	
	}
	
	/**
     * 
     *
     * @param	mixed	$to
     */

			public function proEmailGetData($param) {
        if (isset($this->{$param})) {
          return $this->{$param};
        }
      }
			
	public function setTo($to) {
		$this->to = $to;
	}
	
	/**
     * 
     *
     * @param	string	$from
     */
	public function setFrom($from) {
		$this->from = $from;
	}
	
	/**
     * 
     *
     * @param	string	$sender
     */
	public function setSender($sender) {
		$this->sender = $sender;
	}
	
	/**
     * 
     *
     * @param	string	$reply_to
     */
	public function setReplyTo($reply_to) {
		$this->reply_to = $reply_to;
	}
	
	/**
     * 
     *
     * @param	string	$subject
     */
	public function setSubject($subject) {
		$this->subject = $subject;
	}
	
	/**
     * 
     *
     * @param	string	$text
     */
	public function setText($text) {
		$this->text = $text;
	}
	
	/**
     * 
     *
     * @param	string	$html
     */
	public function setHtml($html) {
		$this->html = $html;
	}
	
	/**
     * 
     *
     * @param	string	$filename
     */
	public function addAttachment($filename) {
		$this->attachments[] = $filename;
	}
	
	/**
     * 
     *
     */
	protected $cc;
  protected $bcc;

  public function addCC($mail) {
    $this->cc[] = $mail;
  }
  
  public function addBCC($mail) {
    $this->bcc[] = $mail;
  }
	
  public function send() {
    if ((isset($this->protocol) && $this->protocol == 'gkdapi') || isset($this->adaptor) && get_class($this->adaptor) == 'Mail\GKDAPI') {
      $adaptor = new Mail\GKDAPI();
      foreach (get_object_vars($this) as $key => $value) {
        $adaptor->$key = $value;
        
        if ($key == 'parameter' && isset($value['api'])) {
          $currentApi = $value['api'];
        }
      }

      $adaptor->send();
      
      return $currentApi;
    }
    
    if (!defined('GKD_MAIL_QUEUE') && method_exists($this, 'saveToQueue')) {
      $this->saveToQueue();
      return;
    }
    
		if (!$this->to) {
			trigger_error('Error: E-Mail to required!');
			exit();
		}

		if (!$this->from) {
			trigger_error('Error: E-Mail from required!');
			exit();
		}

		if (!$this->sender) {
			trigger_error('Error: E-Mail sender required!');
			exit();
		}

		if (!$this->subject) {
			trigger_error('Error: E-Mail subject required!');
			exit();
		}

		if ((!$this->text) && (!$this->html)) {
			trigger_error('Error: E-Mail message required!');
			exit();
		}
    
    $reply_to = $this->sender;
    
		if (!empty($this->reply_to)) {
			$reply_to = $this->reply_to;
		} else if (!empty($this->replyto)) {
			$reply_to = $this->replyto;
		}
    
    $mail = new PHPMailer;
    $mail->CharSet = 'UTF-8';
    
    $mail->SetFrom($this->from, $this->sender);
		$mail->AddReplyTo($reply_to);
    
    foreach ((array) $this->to as $to) {
      $mail->AddAddress($to);
    }
    
    foreach ((array) $this->cc as $cc) {
      $mail->AddCC($cc);
    }
    
    foreach ((array) $this->bcc as $bcc) {
      $mail->AddBCC($bcc);
    }

    $mail->isHTML($this->html);
    
    $mail->Subject = $this->subject;
    if ($this->html) {
      $mail->MsgHTML($this->html);
      if ($this->text) {
        $mail->AltBody = $this->text;
      }
    } else {
      $mail->Body = $this->text;
    }

		foreach ($this->attachments as $attachment) {
			if (file_exists($attachment)) {
        $mail->addAttachment($attachment);
			}
		}

    if (version_compare(VERSION, '3', '>=')) {
      $adaptor = strtolower(get_class($this->adaptor));
      $adaptor = trim(strstr($adaptor, '\\'), '\\');
    } else {
      $adaptor = $this->protocol;
    }
    
    if ($adaptor == 'smtp') {
      include_once(DIR_SYSTEM . 'library/phpmailer/SMTP.php');
			$mail->IsSMTP();
      if (version_compare(VERSION, '2', '>=')) {
        $mail->Host = str_replace(array('tls://', 'ssl://'), '', $this->smtp_hostname);
        if($this->smtp_port == '587' || (substr($this->smtp_hostname, 0, 3) == 'tls')) {
          $mail->SMTPSecure = 'tls';
        } elseif($this->smtp_port == '465' || (substr($this->smtp_hostname, 0, 3) == 'ssl')) {
          $mail->SMTPSecure = 'ssl';
        }
        $mail->Port = $this->smtp_port;
        if (!empty($this->smtp_username)) {
          $mail->SMTPAuth = true;
          $mail->Username = $this->smtp_username;
          $mail->Password = $this->smtp_password;
        }
      } else {
        $mail->Host = str_replace(array('tls://', 'ssl://'), '', $this->hostname);
        if($this->port == '587' || (substr($this->hostname, 0, 3) == 'tls')) {
          $mail->SMTPSecure = 'tls';
        } elseif($this->port == '465' || (substr($this->hostname, 0, 3) == 'ssl')) {
          $mail->SMTPSecure = 'ssl';
        }
        $mail->Port = $this->port;
        if (!empty($this->username)) {
          $mail->SMTPAuth = true;
          $mail->Username = $this->username;
          $mail->Password = $this->password;
        }
      }
		}
    
		try {
      if (!$mail->Send()) {
        echo 'PHPMailer Error: ' . $mail->ErrorInfo;
        error_log('PHPMailer Error: ' . $mail->ErrorInfo);
      }
    } catch (Exception $e) {
      error_log('PHPMailer Error: ' . $mail->ErrorInfo);
    }
	}
  
  function send_default() {
      
		if (!$this->to) {
			throw new \Exception('Error: E-Mail to required!');
		}

		if (!$this->from) {
			throw new \Exception('Error: E-Mail from required!');
		}

		if (!$this->sender) {
			throw new \Exception('Error: E-Mail sender required!');
		}

		if (!$this->subject) {
			throw new \Exception('Error: E-Mail subject required!');
		}

		if ((!$this->text) && (!$this->html)) {
			throw new \Exception('Error: E-Mail message required!');
		}
		
		foreach (get_object_vars($this) as $key => $value) {
			$this->adaptor->$key = $value;
		}
		
		$this->adaptor->send();
	}
}