<?php
namespace Template;
final class Twig {
	private $data = array();

	public function set($key, $value) {
		$this->data[$key] = $value;
	}
	
	public function render($filename, $code = '') {
		if (!$code) {
			$file = DIR_TEMPLATE . $filename . '.twig';

			if (defined('DIR_CATALOG') && is_file(DIR_MODIFICATION . 'admin/view/template/' . $filename . '.twig')) {	
                $code = file_get_contents(DIR_MODIFICATION . 'admin/view/template/' . $filename . '.twig');
            } elseif (is_file(DIR_MODIFICATION . 'catalog/view/theme/' . $filename . '.twig')) {
                $code = file_get_contents(DIR_MODIFICATION . 'catalog/view/theme/' . $filename . '.twig');
            } elseif (is_file($file)) {
				$code = file_get_contents($file);
			} else {
				throw new \Exception('Error: Could not load template ' . $file . '!');
				exit();
			}
		}

		// initialize Twig environment
		$config = array(
			'autoescape'  => false,
			'debug'       => false,
			'auto_reload' => true,
			'cache'       => DIR_CACHE . 'template/'
		);

		try {
			$loader = new \Twig\Loader\ArrayLoader(array($filename . '.twig' => $code));

            // Journal Theme Modification
            if (defined('JOURNAL3_ACTIVE')) {
                $j3loader = new \Twig_Loader_Filesystem();

			    if (defined('DIR_CATALOG') && is_dir(DIR_MODIFICATION . 'admin/view/template/')) {
			        $j3loader->addPath(DIR_MODIFICATION . 'admin/view/template/');
		        } elseif (is_dir(DIR_MODIFICATION . 'catalog/view/theme/')) {
			        $j3loader->addPath(DIR_MODIFICATION . 'catalog/view/theme/');
		        }

		        $j3loader->addPath(DIR_TEMPLATE);

			    $loader = new \Twig\Loader\ChainLoader(array($loader, $j3loader));
            }
		    // End Journal Theme Modification
            

			$twig = new \Twig\Environment($loader, $config);


			if (strpos($filename, "extension/module/admin_quick_edit") !== FALSE || strpos($filename, "extension/module/aqe") !== FALSE) {
				$twig->addFilter(new \Twig\TwigFilter('addslashes', 'addslashes'));
			}
			
			return $twig->render($filename . '.twig', $this->data);
		} catch (Exception $e) {
			trigger_error('Error: Could not load template ' . $filename . '!');
			exit();
		}	
	}	
}
