<?php

trait trait_lbt_customer {

    private $error;

    /**
     *
     */
    private function validate_by_telephone($telephone) {

        $this->load->model('extension/module/lbt_dao');
        $customer_info = $this->model_extension_module_lbt_dao->get_customer_by_telephone($telephone);
        if (!$customer_info) {

            $this->load->language('account/forgotten');
            $this->load->language('extension/module/lbt');
            $this->error = $this->language->get('error_telephone');

            return false;
        }

        if (!$this->validate_approval($customer_info)) {
            return false;
        }

        return $customer_info;
    }

    /**
     *
     */
    private function validate_approval($customer_info) {

        if ($customer_info && !$customer_info['status']) {

            $this->load->language('account/forgotten');
            $this->load->language('extension/module/lbt');
            $this->error = $this->language->get('error_approved');
            return false;
        }

        return true;
    }

    /**
     *
     */
    private function get_iso_code_by_customer_id($customer_id) {

        $this->load->model('extension/module/lbt_address');
        $addresses = $this->model_extension_module_lbt_address->getAddresses($customer_id);

        if (!$addresses) {
            return "";
        }

        $address = array_shift($addresses);
        return $address['iso_code_2'];
    }

}